/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.impl.OptionsManager;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.PacketTracerConnection;
import com.cisco.pt.ptmp.impl.LowLevelReadThread;
import com.cisco.pt.util.Utilities;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketTracerConnectionImpl
implements PacketTracerConnection {
    private static Log logger = LogFactory.getLog(PacketTracerConnectionImpl.class);
    private String host;
    private int port;
    private ConnectionNegotiationProperties connectionNegotiationProperties;
    private SocketChannel socketChannel;
    private Selector selector;
    protected int readCount = 0;
    protected int writeCount = 0;
    protected int lowLevelReadErrorCount = 0;
    protected LowLevelReadThread readThread;
    protected Object currentStatus = STATUS_NEW;
    protected String currentStatusReason = "PacketTracerConnection instantiated";
    protected Throwable currentStatusThrowable;
    public static final Object STATUS_CLOSED = "CLOSED";
    public static final Object STATUS_DOWN = "DOWN";
    public static final Object STATUS_NEW = "NEW";
    public static final Object STATUS_UP = "UP";

    public PacketTracerConnectionImpl(String host, int port) {
        this(host, port, null);
    }

    public PacketTracerConnectionImpl(String host, int port, ConnectionNegotiationProperties connectionNegotiationProperties) {
        this.host = host;
        this.port = port;
        this.connectionNegotiationProperties = connectionNegotiationProperties == null ? OptionsManager.getInstance().getConnectOpts() : connectionNegotiationProperties;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating PacketTracerConnection instance with host:[" + host + "] port:[" + port + "]"));
            logger.info((Object)("connectionNegotiationProperties: [" + this.connectionNegotiationProperties + "]"));
        }
        this.readThread = new LowLevelReadThread(this);
    }

    @Override
    public boolean connect() {
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Attempting to open connection to host:[" + this.host + "] port:[" + this.port + "]"));
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
            this.socketChannel = SocketChannel.open(inetSocketAddress);
            this.socketChannel.configureBlocking(false);
            this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            this.selector = Selector.open();
            this.socketChannel.register(this.selector, 1);
            this.setStatus(STATUS_UP, "PacketTracerConnection successfully opened");
            logger.info((Object)("Succesfully connected to host:[" + this.host + "] port:[" + this.port + "]\n\tSocket channel is blocking: [" + this.socketChannel.isBlocking() + "]"));
        }
        catch (Throwable t) {
            Utilities.check(t);
            this.setStatus(STATUS_DOWN, "Error while attempting to open connection: ", t);
        }
        return this.isUp();
    }

    @Override
    public boolean reconnect() {
        if (!this.isUp()) {
            this.connect();
            if (this.isUp()) {
                this.reconnectLowLevelReadThread();
            }
        }
        return this.isUp();
    }

    @Override
    public void connectLowLevelReadThread() {
        this.readThread.start();
    }

    @Override
    public void reconnectLowLevelReadThread() {
        this.connectLowLevelReadThread();
    }

    @Override
    public void disconnectLowLevelReadThread() {
        this.readThread.shouldStop();
    }

    @Override
    public void disconnect() {
        try {
            logger.info((Object)("Attempting to close connection to host:[" + this.host + "] port:[" + this.port + "]"));
            this.disconnectLowLevelReadThread();
            this.selector.close();
            this.socketChannel.close();
            this.selector = null;
            this.socketChannel = null;
            this.setStatus(STATUS_CLOSED, "PacketTracerConnection closed by request");
            logger.debug((Object)("Succesfully closed connection to host:[" + this.host + "] port:[" + this.port + "]"));
        }
        catch (Throwable t) {
            Utilities.check(t);
            this.setStatus(STATUS_DOWN, "Error while attempting to close connection: ", t);
        }
    }

    @Override
    public boolean isUp() {
        return this.currentStatus == STATUS_UP;
    }

    @Override
    public boolean isDown() {
        return !this.isUp();
    }

    @Override
    public Object getCurrentStatus() {
        return this.currentStatus;
    }

    @Override
    public String getCurrentStatusReason() {
        return this.currentStatusReason;
    }

    @Override
    public Throwable getCurrentStatusThrowable() {
        return this.currentStatusThrowable;
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel != null && this.socketChannel.isOpen() && this.socketChannel.socket() != null && !this.socketChannel.socket().isClosed() && !this.socketChannel.socket().isInputShutdown() && !this.socketChannel.socket().isOutputShutdown();
    }

    @Override
    public ByteBuffer getNextMessage() throws IOException, InterruptedException {
        return this.readThread.getNextMessage();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.innerRead(byteBuffer);
        }
        catch (IOException e) {
            this.setStatus(STATUS_DOWN, "Error during read: ", e);
            throw e;
        }
        catch (Throwable t) {
            Utilities.check(t);
            this.setStatus(STATUS_DOWN, "Error during read: ", t);
            throw new Error("Error during read", t);
        }
    }

    protected int innerRead(ByteBuffer byteBuffer) throws IOException {
        int read = -24;
        int selected = this.selector.select(this.connectionNegotiationProperties.getKeepAlivePeriod() * 1000 * 3);
        if (selected <= 0) {
            throw new IOException("Timed out");
        }
        Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
        while (selectedKeys.hasNext()) {
            SelectionKey key = selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid() || !key.isReadable()) continue;
            this.incrementReadCount();
            read = this.socketChannel.read(byteBuffer);
            if (read != -1) continue;
            throw new IOException("Timed out");
        }
        return read;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.innerWrite(byteBuffer);
        }
        catch (IOException e) {
            this.setStatus(STATUS_DOWN, "Error during write: ", e);
            throw e;
        }
        catch (Throwable t) {
            Utilities.check(t);
            this.setStatus(STATUS_DOWN, "Error during write: ", t);
            throw new IOException("Error during read", t);
        }
    }

    protected int innerWrite(ByteBuffer byteBuffer) throws IOException {
        int totalWritten = 0;
        while (byteBuffer.hasRemaining()) {
            this.incrementWriteCount();
            int numberWritten = this.socketChannel.write(byteBuffer);
            totalWritten += numberWritten;
            if (numberWritten > 0) continue;
            throw new IOException("Error writing to server");
        }
        return totalWritten;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public ConnectionNegotiationProperties connectionNegotiationProperties() {
        return this.connectionNegotiationProperties;
    }

    public int getLowLevelReadErrorCount() {
        return this.lowLevelReadErrorCount;
    }

    @Override
    public synchronized void noteLowLevelReadError(Throwable t) {
        ++this.lowLevelReadErrorCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    protected synchronized void incrementWriteCount() {
        ++this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    protected synchronized void incrementReadCount() {
        ++this.readCount;
    }

    protected void setStatus(Object status, String message) {
        this.currentStatus = status;
        this.currentStatusReason = message;
        this.currentStatusThrowable = null;
    }

    protected void setStatus(Object status, String message, Throwable t) {
        this.currentStatus = status;
        this.currentStatusReason = message + t.getMessage();
        this.currentStatusThrowable = t;
    }
}

