/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class Attempt {
    public static final int RESULT_SUCCESSFUL = 0;
    public static final int RESULT_ERROR = 1;
    private final int resultCode;
    private final String feedback;

    public Attempt() {
        this(0, null);
    }

    public Attempt(Throwable e) {
        this(1, e.getMessage());
    }

    public Attempt(int resultCode, String feedback) {
        this.resultCode = resultCode;
        this.feedback = feedback;
    }

    public String toString() {
        String isSuccStr = String.valueOf(this.isSuccessful());
        return String.format("Attempt [isSuccessful=%s, feedback=%s]", isSuccStr, this.getFeedback());
    }

    public boolean isSuccessful() {
        return this.resultCode == 0;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getFeedback() {
        return this.getFeedback(String.class);
    }

    public <T> T getFeedback(Class<T> type) {
        if (type == null || type.equals(String.class)) {
            return (T)this.feedback;
        }
        if (type.equals(Byte.class)) {
            return type.cast(Byte.valueOf(this.feedback));
        }
        if (type.equals(Short.class)) {
            return type.cast(Short.valueOf(this.feedback));
        }
        if (type.equals(Integer.class)) {
            return type.cast(Integer.valueOf(this.feedback));
        }
        if (type.equals(Long.class)) {
            return type.cast(Long.valueOf(this.feedback));
        }
        if (type.equals(Float.class)) {
            return type.cast(Float.valueOf(this.feedback));
        }
        if (type.equals(Double.class)) {
            return type.cast(Double.valueOf(this.feedback));
        }
        if (type.equals(Boolean.class)) {
            return type.cast(Boolean.valueOf(this.feedback));
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(this.feedback, type);
        }
        catch (IOException iOException) {
            return type.cast(this.feedback);
        }
    }
}

