/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class Deserializers {
    public static void register(ObjectMapper mapper, Class<?> ... desClasses) {
        SimpleModule module = new SimpleModule();
        Class<?>[] classArray = desClasses;
        int n = desClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            try {
                ACustomDeserializer d = (ACustomDeserializer)((Object)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                module.addDeserializer(d.handledType(), (JsonDeserializer)d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        mapper.registerModule((Module)module);
    }

    public static abstract class ACustomDeserializer<T>
    extends StdDeserializer<T> {
        public ACustomDeserializer() {
            this(null);
        }

        public ACustomDeserializer(Class<T> t) {
            super(t);
        }

        public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;
    }

    public static class PointDeserializer
    extends ACustomDeserializer<Point> {
        public PointDeserializer() {
            super(Point.class);
        }

        @Override
        public Point deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            double z;
            double y;
            double x;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isArray()) {
                if (node.size() < 2) {
                    throw new IOException("Array must be at least 2-length.");
                }
                x = node.get(0).asDouble();
                y = node.get(1).asDouble();
                z = node.size() > 2 ? node.get(2).asDouble() : 0.0;
            } else if (node.has("x") && node.has("y")) {
                x = node.get("x").asDouble();
                y = node.get("y").asDouble();
                z = node.has("z") ? node.get("z").asDouble() : 0.0;
            } else if (node.has("lat") && node.has("lon")) {
                x = node.get("lat").asDouble();
                y = node.get("lon").asDouble();
                z = 0.0;
            } else {
                throw new IOException("Object must have at least keys 'x' and 'y' or 'lat' and 'lon'");
            }
            return new Point(x, y, z);
        }
    }

    public static class PositionDeserializer
    extends ACustomDeserializer<Position> {
        public PositionDeserializer() {
            super(Position.class);
        }

        @Override
        public Position deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            double vr;
            double r;
            double z;
            double y;
            double x;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isArray()) {
                int size = node.size();
                if (size < 2 || size > 5) {
                    throw new IOException("Array must be a length between 2 and 5.");
                }
                x = node.get(0).asDouble();
                y = node.get(1).asDouble();
                if (size == 3) {
                    z = 0.0;
                    r = node.get(2).asDouble();
                    vr = 0.0;
                } else {
                    z = node.get(2).asDouble();
                    r = node.get(3).asDouble();
                    vr = size == 5 ? node.get(4).asDouble() : 0.0;
                }
            } else {
                if (!node.has("x") || !node.has("y")) {
                    throw new IOException("Object must have at least keys 'x' and 'y'");
                }
                if (node.has("x") && node.has("y")) {
                    x = node.get("x").asDouble();
                    y = node.get("y").asDouble();
                } else if (node.has("lat") && node.has("lon")) {
                    x = node.get("lat").asDouble();
                    y = node.get("lon").asDouble();
                } else {
                    throw new IOException("Object must have at least keys 'x' and 'y' or 'lat' and 'lon'");
                }
                z = node.has("z") ? node.get("z").asDouble() : 0.0;
                double d = r = node.has("rotation") ? node.get("rotation").asDouble() : 0.0;
                vr = node.has("vertical_rotation") ? node.get("vertical_rotation").asDouble() : (node.has("verticalRotation") ? node.get("verticalRotation").asDouble() : 0.0);
            }
            return new Position(x, y, z, r, vr);
        }
    }
}

