/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.engine.AgentConstants;
import com.anylogic.engine.TimeUnits;
import com.anylogic.libraries.pypeline.Attempt;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureAttempt
implements Future<Attempt> {
    private final Process process;
    private boolean cancelled = false;
    private boolean completed = false;
    private StringBuilder syserr = new StringBuilder();
    private StringBuilder sysout = new StringBuilder();
    private Attempt result = null;

    public FutureAttempt(Process process) {
        this.process = process;
    }

    public FutureAttempt(Attempt result) {
        this.process = null;
        this.completed = true;
        this.result = result;
    }

    private void updateResult() throws IOException {
        if (this.completed) {
            return;
        }
        this.syserr.append(new String(this.process.getErrorStream().readNBytes(this.process.getErrorStream().available())));
        this.sysout.append(new String(this.process.getInputStream().readNBytes(this.process.getInputStream().available())));
        StringBuilder feedback = new StringBuilder();
        feedback.append((CharSequence)this.syserr).append("\n").append((CharSequence)this.sysout);
        this.result = new Attempt(this.sysout.length() > 0 || this.syserr.length() == 0 ? 0 : 1, feedback.toString().trim());
        if (this.isDone()) {
            this.completed = true;
        }
    }

    @Override
    public Attempt get() {
        if (!this.completed) {
            try {
                this.updateResult();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }

    @Override
    public Attempt get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean processCompleted;
        if (this.completed || timeout <= 0L) {
            return this.get();
        }
        try {
            processCompleted = this.process.waitFor(timeout, unit);
        }
        catch (InterruptedException e) {
            this.cancel(true);
            throw e;
        }
        if (processCompleted) {
            return this.get();
        }
        throw new TimeoutException("The operation timed out.");
    }

    public Attempt get(long timeout, TimeUnits unit) throws InterruptedException, TimeoutException {
        TimeUnit jUnit = null;
        switch (unit) {
            case MILLISECOND: {
                jUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case SECOND: {
                jUnit = TimeUnit.SECONDS;
                break;
            }
            case MINUTE: {
                jUnit = TimeUnit.MINUTES;
                break;
            }
            case HOUR: {
                jUnit = TimeUnit.HOURS;
                break;
            }
            case DAY: {
                jUnit = TimeUnit.DAYS;
                break;
            }
            case WEEK: 
            case MONTH: 
            case YEAR: {
                timeout = (long)unit.convertTo((double)timeout * 1.0, AgentConstants.DAY);
                jUnit = TimeUnit.DAYS;
            }
        }
        return this.get(timeout, jUnit);
    }

    @Override
    public boolean isDone() {
        return !this.process.isAlive();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            this.process.destroy();
            this.cancelled = true;
        }
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

