/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.engine.AbstractLinkToAgent;
import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.CustomDistributionAbstract;
import com.anylogic.engine.EventOriginator;
import com.anylogic.engine.IStatechartState;
import com.anylogic.engine.LinkToAgentAnimationSettings;
import com.anylogic.engine.Pair;
import com.anylogic.engine.Port;
import com.anylogic.engine.SDIntegrationManager;
import com.anylogic.engine.Scale;
import com.anylogic.engine.analysis.Chart2DPlot;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.DataItem;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.analysis.Histogram;
import com.anylogic.engine.analysis.Histogram2D;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.StatisticsContinuous;
import com.anylogic.engine.analysis.StatisticsDiscrete;
import com.anylogic.engine.presentation.Shape;
import com.anylogic.libraries.pypeline.CustomAnnotationIntrospector;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class JsonFilter {
    private ObjectMapper parent;
    public static final boolean defaultBlacklistAutogeneratedSetting = true;
    public static final HashSet<Class<?>> defaultBlacklistedClasses = new HashSet<Class>(Arrays.asList(Color.class, Font.class, Shape.class, EventOriginator.class, IStatechartState.class, AbstractLinkToAgent.class, Scale.class, CustomDistributionAbstract.class, Random.class, Histogram.Appearance.class, Histogram2D.Appearance.class, Chart2DPlot.Appearance.class, SDIntegrationManager.class, LinkToAgentAnimationSettings.class, Port.class));
    public static final HashSet<String> defaultBlacklistedPackages = new HashSet<String>(Arrays.asList("com.anylogic.libraries.pypeline", "anylogic_jsonifier_library", "com.anylogic.libraries.processmodeling", "com.anylogic.libraries.material_handling", "com.anylogic.libraries.pedestrian", "com.anylogic.libraries.rail", "com.anylogic.libraries.road", "com.anylogic.libraries.fluid", "com.anylogic.engine.markup", "com.anylogic.engine.connectivity", "com.anylogic.engine.presentation"));
    public static final HashSet<String> defaultBlacklistedNames = new HashSet<String>(Arrays.asList(".+_xjal", "serialVersionUID"));
    public static final boolean defaultWhitelistAutogeneratedSetting = false;
    public static final HashSet<Class<?>> defaultWhitelistedClasses = new HashSet<Class>(Arrays.asList(Number.class, Boolean.class, Agent.class, AgentList.class, ChartItem.class, DataItem.class, DataSet.class, HistogramData.class, StatisticsContinuous.class, StatisticsDiscrete.class));
    public static final HashSet<String> defaultWhitelistedPackages = new HashSet<String>(Arrays.asList("java.util", "java.lang"));
    public static final HashSet<String> defaultWhitelistedNames = new HashSet<String>(Arrays.asList(new String[0]));
    private HashSet<Class<?>> includedClasses = new HashSet();
    private HashSet<String> includedPackages = new HashSet();
    private HashSet<String> includedNames = new HashSet();
    private boolean includeAutogeneratedObjects = false;
    private boolean inBlacklistMode = true;

    public JsonFilter(ObjectMapper parentMapper) {
        this(parentMapper, true);
    }

    public JsonFilter(ObjectMapper parentMapper, boolean loadDefault) {
        this(parentMapper, true, loadDefault);
    }

    public JsonFilter(ObjectMapper parentMapper, boolean inBlacklistMode, boolean loadDefault) {
        this.parent = parentMapper;
        this.inBlacklistMode = inBlacklistMode;
        boolean bl = this.includeAutogeneratedObjects = inBlacklistMode;
        if (loadDefault) {
            this.resetNames();
            this.resetClasses();
            this.resetPackages();
        }
    }

    public JsonFilter(ObjectMapper parentMapper, boolean inBlacklistMode, boolean includeAutogenerateds, String[] includedPackages, Class<?>[] includedClasses, String[] includedNames) {
        this.parent = parentMapper;
        this.inBlacklistMode = inBlacklistMode;
        this.includeAutogeneratedObjects = includeAutogenerateds;
        if (includedPackages == null) {
            this.clearPackages();
        } else {
            this.includePackages(includedPackages);
        }
        if (includedClasses == null) {
            this.clearClasses();
        } else {
            this.includeClasses(includedClasses);
        }
        if (includedNames == null) {
            this.clearNames();
        } else {
            this.includeNames(includedNames);
        }
    }

    private static boolean looksAutogenerated(String name, int modifiers, Class<?> clazz) {
        if (name != null) {
            if (name.startsWith("_ds_") && (clazz == null || DataSet.class.isAssignableFrom(clazz))) {
                return true;
            }
            if (name.endsWith("_xjal")) {
                return true;
            }
            if (name.equals("_origin_VA")) {
                return true;
            }
        }
        return clazz != null && name != null && name.startsWith("_") && Modifier.isProtected(modifiers) && Modifier.isStatic(modifiers);
    }

    public boolean skipJsonifying(String name, int modifiers, Class<?> clazz) {
        boolean pkgIncluded;
        boolean clsIncluded;
        boolean nameIncluded;
        boolean skip = false;
        if (JsonFilter.looksAutogenerated(name, modifiers, clazz)) {
            skip = this.inBlacklistMode == this.includeAutogeneratedObjects;
        }
        boolean bl = nameIncluded = name != null && this.includedNames.stream().anyMatch(n -> name.matches((String)n));
        if (this.inBlacklistMode && nameIncluded) {
            skip = true;
        }
        boolean bl2 = clsIncluded = clazz != null && this.includedClasses.stream().anyMatch(c -> c.isAssignableFrom(clazz));
        if (this.inBlacklistMode && clsIncluded) {
            skip = true;
        }
        boolean bl3 = pkgIncluded = clazz != null && this.includedPackages.contains(clazz.getPackageName());
        if (this.inBlacklistMode && pkgIncluded) {
            skip = true;
        }
        if (!(this.inBlacklistMode || nameIncluded || clsIncluded || pkgIncluded)) {
            skip = true;
        }
        return skip;
    }

    public boolean skipJsonifying(String name) {
        return this.skipJsonifying(name, 1, null);
    }

    public boolean skipJsonifying(Class<?> clazz) {
        return this.skipJsonifying(null, 1, clazz);
    }

    public Map<Pair<String, Class<?>>, Boolean> skipJsonifyingReport(Object obj) {
        HashMap report = new HashMap();
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            String name = f.getName();
            Class<?> cls = f.getType();
            report.put(new Pair((Object)name, cls), this.skipJsonifying(name, f.getModifiers(), cls));
            ++n2;
        }
        return report;
    }

    public HashSet<String> getIncludedPackages() {
        return new HashSet<String>(this.includedPackages);
    }

    public HashSet<Class<?>> getIncludedClasses() {
        return new HashSet(this.includedClasses);
    }

    public HashSet<String> getIncludedNames() {
        return new HashSet<String>(this.includedNames);
    }

    public boolean isAutogeneratedIncluded() {
        return this.includeAutogeneratedObjects;
    }

    public boolean isInBlacklistMode() {
        return this.inBlacklistMode;
    }

    public boolean isInWhitelistMode() {
        return !this.inBlacklistMode;
    }

    public JsonFilter setMode(boolean inBlacklist) {
        return this.setMode(inBlacklist, true);
    }

    public JsonFilter setMode(boolean inBlacklist, boolean loadDefault) {
        if (this.inBlacklistMode == inBlacklist) {
            return this;
        }
        this.inBlacklistMode = inBlacklist;
        if (loadDefault) {
            return this.resetAll();
        }
        return this.clearAll();
    }

    public JsonFilter setAutogenerated(boolean include) {
        if (this.includeAutogeneratedObjects == include) {
            return this;
        }
        this.includeAutogeneratedObjects = include;
        return this.update();
    }

    public JsonFilter includeAutogenerated() {
        return this.setAutogenerated(true);
    }

    public JsonFilter includePackages(String ... pkgs) {
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            this.includedPackages.add(pkg);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter includeClasses(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.includedClasses.add(cls);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter includeNames(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.includedNames.add(name);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter excludeAutogenerated() {
        return this.setAutogenerated(false);
    }

    public JsonFilter excludePackages(String ... pkgs) {
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            this.includedPackages.remove(pkg);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter excludeClasses(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.includedClasses.remove(cls);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter excludeNames(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.includedNames.remove(name);
            ++n2;
        }
        return this.update();
    }

    public JsonFilter clearPackages() {
        this.includedPackages.clear();
        return this.update();
    }

    public JsonFilter clearClasses() {
        this.includedClasses.clear();
        return this.update();
    }

    public JsonFilter clearNames() {
        this.includedNames.clear();
        return this.update();
    }

    public JsonFilter clearAll() {
        this.includedPackages.clear();
        this.includedClasses.clear();
        this.includedNames.clear();
        return this.update();
    }

    public JsonFilter resetAutogenerated() {
        boolean include = this.isInBlacklistMode();
        return this.setAutogenerated(include);
    }

    public JsonFilter resetPackages() {
        this.clearPackages();
        if (this.inBlacklistMode) {
            for (String p : defaultBlacklistedPackages) {
                this.includedPackages.add(p);
            }
        } else {
            for (String p : defaultWhitelistedPackages) {
                this.includedPackages.add(p);
            }
        }
        return this.update();
    }

    public JsonFilter resetClasses() {
        this.clearClasses();
        if (this.inBlacklistMode) {
            for (Class<?> c : defaultBlacklistedClasses) {
                this.includedClasses.add(c);
            }
        } else {
            for (Class<?> c : defaultWhitelistedClasses) {
                this.includedClasses.add(c);
            }
        }
        return this.update();
    }

    public JsonFilter resetNames() {
        this.clearNames();
        if (this.inBlacklistMode) {
            for (String n : defaultBlacklistedNames) {
                this.includedNames.add(n);
            }
        } else {
            for (String n : defaultWhitelistedNames) {
                this.includedNames.add(n);
            }
        }
        return this.update();
    }

    public JsonFilter resetAll() {
        return this.resetAutogenerated().resetPackages().resetClasses().resetNames();
    }

    private JsonFilter update() {
        this.parent.setAnnotationIntrospector((AnnotationIntrospector)new CustomAnnotationIntrospector(this));
        return this;
    }

    public String toString() {
        return String.format("JsonFilter[%s | %s autogen, %s names, %s classes, %s packages]", this.inBlacklistMode ? "BLACK" : "WHITE", this.includeAutogeneratedObjects ? "YES" : "NO", this.includedNames.size(), this.includedClasses.size(), this.includedPackages.size());
    }
}

