/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.cloud.util.ExceptionUtils;
import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.AnyLogicCustomProposalPriority;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Engine;
import com.anylogic.engine.Pair;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Scale;
import com.anylogic.engine.UtilitiesArray;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.analysis.Histogram2DData;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.HistogramSimpleData;
import com.anylogic.engine.analysis.StatisticsContinuous;
import com.anylogic.engine.analysis.StatisticsDiscrete;
import com.anylogic.engine.elements.IElementDescriptor;
import com.anylogic.engine.markup.Level;
import com.anylogic.engine.markup.LevelElement;
import com.anylogic.engine.presentation.ColorConstants;
import com.anylogic.engine.presentation.ModelElementDescriptorUtils;
import com.anylogic.engine.presentation.ShapeImage;
import com.anylogic.engine.presentation.ShapeModelElementsGroup;
import com.anylogic.engine.presentation.ShapeText;
import com.anylogic.engine.presentation.ShapeTopLevelPresentationGroup;
import com.anylogic.engine.presentation.ViewArea;
import com.anylogic.libraries.pypeline.Attempt;
import com.anylogic.libraries.pypeline.FutureAttempt;
import com.anylogic.libraries.pypeline.Jsonifier;
import com.anylogic.libraries.pypeline.PyException;
import com.anylogic.libraries.pypeline.PySubProcess;
import com.anylogic.libraries.pypeline.PythonCommandType;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import spark.utils.IOUtils;

public class PyCommunicator
extends Jsonifier {
    public boolean enable;
    public boolean loadLastWorkingConfig;
    public PythonCommandType pythonCommandType;
    public String pythonCommand;
    public String pythonExecPath;
    public boolean throwErrorOnFailedAttempt;
    public boolean redirectPyOutput;
    @AnyLogicInternalCodegenAPI
    private static String[] _parameterNames_xjal;
    private PySubProcess py;
    public static final PythonCommandType PYTHON;
    public static final PythonCommandType PYTHON2;
    public static final PythonCommandType PYTHON3;
    public static final PythonCommandType PYTHON_OTHER;
    public static final PythonCommandType PYTHON_PATH;
    public final String PROPERTIES_FILENAME = "pypeline.properties";
    public LinkedList<Pair<String, Attempt>> history = new LinkedList();
    private ArrayList<String> serverPyLines = new ArrayList();
    static ArrayList<FutureAttempt> headlessAttempts;
    @AnyLogicInternalCodegenAPI
    private static Map<String, IElementDescriptor> elementDesciptors_xjal;
    @AnyLogicCustomProposalPriority(type=AnyLogicCustomProposalPriority.Type.STATIC_ELEMENT)
    public static final Scale scale;
    @AnyLogicInternalCodegenAPI
    protected static final int _STATECHART_COUNT_xjal = 0;
    public ViewArea _origin_VA = new ViewArea((Presentable)this, "[Origin]", 0.0, 0.0, 1000.0, 600.0);
    @AnyLogicInternalCodegenAPI
    protected static final Font _text_Font;
    @AnyLogicInternalCodegenAPI
    protected static final int _image2 = 8;
    @AnyLogicInternalCodegenAPI
    protected static final int _text = 9;
    @AnyLogicInternalCodegenAPI
    protected static final int _SHAPE_NEXT_ID_xjal = 10;
    protected ShapeImage image2;
    protected ShapeText text;
    protected Level level;
    private Level[] _getLevels_xjal;
    private static final String[][] condaPaths;
    @AnyLogicInternalCodegenAPI
    private static final long serialVersionUID = -6302082035170351599L;

    static {
        PYTHON = PythonCommandType.PYTHON;
        PYTHON2 = PythonCommandType.PYTHON2;
        PYTHON3 = PythonCommandType.PYTHON3;
        PYTHON_OTHER = PythonCommandType.PYTHON_OTHER;
        PYTHON_PATH = PythonCommandType.PYTHON_PATH;
        headlessAttempts = new ArrayList();
        elementDesciptors_xjal = PyCommunicator.createElementDescriptors(PyCommunicator.class);
        scale = new Scale(10.0);
        _text_Font = new Font("SansSerif", 2, 16);
        condaPaths = new String[][]{{"Library", "mingw-w64", "bin"}, {"Library", "usr", "bin"}, {"Library", "bin"}, {"Scripts"}, {"bin"}};
    }

    @AnyLogicInternalCodegenAPI
    public boolean _enable_DefaultValue_xjal() {
        PyCommunicator self = this;
        return true;
    }

    public void set_enable(boolean value) {
        if (value == this.enable) {
            return;
        }
        boolean _oldValue_xjal = this.enable;
        this.enable = value;
        this.onChange_enable_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_enable() {
        this.onChange_enable_xjal(this.enable);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_enable_xjal(boolean oldValue) {
        if (this.enable) {
            this.connect();
        } else {
            this.disconnect();
        }
    }

    @AnyLogicInternalCodegenAPI
    public boolean _loadLastWorkingConfig_DefaultValue_xjal() {
        PyCommunicator self = this;
        return false;
    }

    public void set_loadLastWorkingConfig(boolean value) {
        if (value == this.loadLastWorkingConfig) {
            return;
        }
        boolean _oldValue_xjal = this.loadLastWorkingConfig;
        this.loadLastWorkingConfig = value;
        this.onChange_loadLastWorkingConfig_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_loadLastWorkingConfig() {
        this.onChange_loadLastWorkingConfig_xjal(this.loadLastWorkingConfig);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_loadLastWorkingConfig_xjal(boolean oldValue) {
    }

    @AnyLogicInternalCodegenAPI
    public PythonCommandType _pythonCommandType_DefaultValue_xjal() {
        PyCommunicator self = this;
        return PYTHON;
    }

    public void set_pythonCommandType(PythonCommandType value) {
        if (value == this.pythonCommandType) {
            return;
        }
        PythonCommandType _oldValue_xjal = this.pythonCommandType;
        this.pythonCommandType = value;
        this.onChange_pythonCommandType_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_pythonCommandType() {
        this.onChange_pythonCommandType_xjal(this.pythonCommandType);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_pythonCommandType_xjal(PythonCommandType oldValue) {
    }

    @AnyLogicInternalCodegenAPI
    public String _pythonCommand_DefaultValue_xjal() {
        PyCommunicator self = this;
        return null;
    }

    public void set_pythonCommand(String value) {
        if (value == this.pythonCommand) {
            return;
        }
        String _oldValue_xjal = this.pythonCommand;
        this.pythonCommand = value;
        this.onChange_pythonCommand_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_pythonCommand() {
        this.onChange_pythonCommand_xjal(this.pythonCommand);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_pythonCommand_xjal(String oldValue) {
    }

    @AnyLogicInternalCodegenAPI
    public String _pythonExecPath_DefaultValue_xjal() {
        PyCommunicator self = this;
        return null;
    }

    public void set_pythonExecPath(String value) {
        if (value == this.pythonExecPath) {
            return;
        }
        String _oldValue_xjal = this.pythonExecPath;
        this.pythonExecPath = value;
        this.onChange_pythonExecPath_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_pythonExecPath() {
        this.onChange_pythonExecPath_xjal(this.pythonExecPath);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_pythonExecPath_xjal(String oldValue) {
    }

    @AnyLogicInternalCodegenAPI
    public boolean _throwErrorOnFailedAttempt_DefaultValue_xjal() {
        PyCommunicator self = this;
        return true;
    }

    public void set_throwErrorOnFailedAttempt(boolean value) {
        if (value == this.throwErrorOnFailedAttempt) {
            return;
        }
        boolean _oldValue_xjal = this.throwErrorOnFailedAttempt;
        this.throwErrorOnFailedAttempt = value;
        this.onChange_throwErrorOnFailedAttempt_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_throwErrorOnFailedAttempt() {
        this.onChange_throwErrorOnFailedAttempt_xjal(this.throwErrorOnFailedAttempt);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_throwErrorOnFailedAttempt_xjal(boolean oldValue) {
    }

    @AnyLogicInternalCodegenAPI
    public boolean _redirectPyOutput_DefaultValue_xjal() {
        PyCommunicator self = this;
        return true;
    }

    public void set_redirectPyOutput(boolean value) {
        if (value == this.redirectPyOutput) {
            return;
        }
        boolean _oldValue_xjal = this.redirectPyOutput;
        this.redirectPyOutput = value;
        this.onChange_redirectPyOutput_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_redirectPyOutput() {
        this.onChange_redirectPyOutput_xjal(this.redirectPyOutput);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_redirectPyOutput_xjal(boolean oldValue) {
        if (this.py != null) {
            this.py.redirectPyOutput = this.redirectPyOutput;
        }
    }

    @Override
    public void setParametersToDefaultValues() {
        super.setParametersToDefaultValues();
        this.enable = this._enable_DefaultValue_xjal();
        this.loadLastWorkingConfig = this._loadLastWorkingConfig_DefaultValue_xjal();
        this.pythonCommandType = this._pythonCommandType_DefaultValue_xjal();
        this.pythonCommand = this._pythonCommand_DefaultValue_xjal();
        this.pythonExecPath = this._pythonExecPath_DefaultValue_xjal();
        this.throwErrorOnFailedAttempt = this._throwErrorOnFailedAttempt_DefaultValue_xjal();
        this.redirectPyOutput = this._redirectPyOutput_DefaultValue_xjal();
    }

    @Override
    public boolean setParameter(String _name_xjal, Object _value_xjal, boolean _callOnChange_xjal) {
        switch (_name_xjal) {
            case "enable": {
                if (_callOnChange_xjal) {
                    this.set_enable((Boolean)_value_xjal);
                } else {
                    this.enable = (Boolean)_value_xjal;
                }
                return true;
            }
            case "loadLastWorkingConfig": {
                if (_callOnChange_xjal) {
                    this.set_loadLastWorkingConfig((Boolean)_value_xjal);
                } else {
                    this.loadLastWorkingConfig = (Boolean)_value_xjal;
                }
                return true;
            }
            case "pythonCommandType": {
                if (_callOnChange_xjal) {
                    this.set_pythonCommandType((PythonCommandType)((Object)_value_xjal));
                } else {
                    this.pythonCommandType = (PythonCommandType)((Object)_value_xjal);
                }
                return true;
            }
            case "pythonCommand": {
                if (_callOnChange_xjal) {
                    this.set_pythonCommand((String)_value_xjal);
                } else {
                    this.pythonCommand = (String)_value_xjal;
                }
                return true;
            }
            case "pythonExecPath": {
                if (_callOnChange_xjal) {
                    this.set_pythonExecPath((String)_value_xjal);
                } else {
                    this.pythonExecPath = (String)_value_xjal;
                }
                return true;
            }
            case "throwErrorOnFailedAttempt": {
                if (_callOnChange_xjal) {
                    this.set_throwErrorOnFailedAttempt((Boolean)_value_xjal);
                } else {
                    this.throwErrorOnFailedAttempt = (Boolean)_value_xjal;
                }
                return true;
            }
            case "redirectPyOutput": {
                if (_callOnChange_xjal) {
                    this.set_redirectPyOutput((Boolean)_value_xjal);
                } else {
                    this.redirectPyOutput = (Boolean)_value_xjal;
                }
                return true;
            }
        }
        return super.setParameter(_name_xjal, _value_xjal, _callOnChange_xjal);
    }

    @Override
    public <T> T getParameter(String _name_xjal) {
        Object _result_xjal;
        switch (_name_xjal) {
            case "enable": {
                _result_xjal = this.enable;
                break;
            }
            case "loadLastWorkingConfig": {
                _result_xjal = this.loadLastWorkingConfig;
                break;
            }
            case "pythonCommandType": {
                _result_xjal = this.pythonCommandType;
                break;
            }
            case "pythonCommand": {
                _result_xjal = this.pythonCommand;
                break;
            }
            case "pythonExecPath": {
                _result_xjal = this.pythonExecPath;
                break;
            }
            case "throwErrorOnFailedAttempt": {
                _result_xjal = this.throwErrorOnFailedAttempt;
                break;
            }
            case "redirectPyOutput": {
                _result_xjal = this.redirectPyOutput;
                break;
            }
            default: {
                _result_xjal = super.getParameter(_name_xjal);
            }
        }
        return _result_xjal;
    }

    @Override
    public String[] getParameterNames() {
        String[] result = _parameterNames_xjal;
        if (result == null) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getParameterNames()));
            list.add("enable");
            list.add("loadLastWorkingConfig");
            list.add("pythonCommandType");
            list.add("pythonCommand");
            list.add("pythonExecPath");
            list.add("throwErrorOnFailedAttempt");
            list.add("redirectPyOutput");
            result = list.toArray(new String[list.size()]);
            _parameterNames_xjal = result;
        }
        return result;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public Map<String, IElementDescriptor> getElementDesciptors() {
        return elementDesciptors_xjal;
    }

    @Override
    public Scale getScale() {
        return scale;
    }

    public Attempt run(String code) {
        Attempt attempt = this.py.exec(code);
        this.history.add(0, (Pair<String, Attempt>)new Pair((Object)code, (Object)attempt));
        this.validateHistoryLimit();
        if (this.throwErrorOnFailedAttempt && !attempt.isSuccessful()) {
            this.error("Failed to run python code; feedback: %s", new Object[]{attempt.getFeedback()});
        }
        return attempt;
    }

    public Attempt run(String ... lines) {
        String code = String.join((CharSequence)"\n", lines);
        return this.run(code);
    }

    public Attempt runResults(String code) {
        Attempt attempt = this.py.eval(code);
        this.history.add(0, (Pair<String, Attempt>)new Pair((Object)code, (Object)attempt));
        this.validateHistoryLimit();
        if (this.throwErrorOnFailedAttempt && !attempt.isSuccessful()) {
            this.error("Failed to run python code; feedback: %s", new Object[]{attempt.getFeedback()});
        }
        return attempt;
    }

    public Attempt runResults(String ... lines) {
        String code = String.join((CharSequence)"\n", lines);
        return this.runResults(code);
    }

    public boolean isConnected() {
        if (this.py == null) {
            return false;
        }
        Attempt attempt = this.py.ping();
        if (this.throwErrorOnFailedAttempt && !attempt.isSuccessful()) {
            this.error(attempt.getFeedback());
        }
        return attempt.isSuccessful();
    }

    private String createServerPy() {
        try {
            Path tmpFile = Files.createTempFile("pypeline-server_", ".py", new FileAttribute[0]);
            tmpFile.toFile().deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile.toFile()));
            for (String line : this.serverPyLines) {
                writer.write(String.valueOf(line) + "\n");
            }
            writer.close();
            return tmpFile.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return this.py == null ? "null" : String.valueOf(this.py.activePyVersion) + "\n" + this.py.activePyPath;
    }

    void initialize() {
        File f;
        if (this.py != null) {
            try {
                this.py.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.loadLastWorkingConfig) {
            this.importProperties();
        }
        if (this.pythonCommandType.equals((Object)PYTHON_OTHER) && this.pythonCommand == null) {
            this.error("Type was set to 'other' [alias] but no alternate alias was provided!");
        } else if (this.pythonCommandType.equals((Object)PYTHON_PATH) && this.pythonExecPath == null) {
            this.error("Type was set to [custom] 'path' but no path was provided!");
        }
        String pathToServerPy = this.createServerPy();
        switch (this.pythonCommandType) {
            case PYTHON: 
            case PYTHON2: 
            case PYTHON3: {
                String newCommand = PySubProcess.convertToCommand(this.pythonCommandType);
                if (this.pythonCommand != null && !this.pythonCommand.equals(newCommand)) {
                    this.warning("Overriding previous Python command (%s) with corrected command (%s), based on set command type.", new Object[]{this.pythonCommand, newCommand});
                }
                this.set_pythonCommand(newCommand);
            }
            case PYTHON_OTHER: {
                String newExecPath = null;
                try {
                    newExecPath = PySubProcess.findPythonPath(this.pythonCommand);
                    if (this.pythonExecPath != null && !this.pythonExecPath.equals(newExecPath)) {
                        this.warning("Overriding previous Python executable path (%s) with corrected path (%s), based on set command type.", new Object[]{this.pythonExecPath, newExecPath});
                    }
                }
                catch (PyException e) {
                    this.error(e, "Failed to find Python executable path based on Python command: " + String.format(this.pythonCommand, new Object[0]));
                }
                this.set_pythonExecPath(newExecPath);
            }
        }
        if (this.pythonExecPath == null) {
            String prefInput = String.valueOf(this.pythonCommandType.toString()) + (this.pythonCommandType.equals((Object)PYTHON_OTHER) ? " - '" + this.pythonCommand + "'" : "");
            String msg = "Could not find any Python executable based on your preferred input (" + prefInput + ").";
            msg = String.valueOf(msg) + "\nPlease check your system or user \"PATH\" variable. This can be printed out in AnyLogic by executing the code: `traceln(System.getenv(\"PATH\"));`";
            msg = String.valueOf(msg) + "\nNote: If you modify the path variable, you may need to restart AnyLogic for the changes to take effect.";
            this.error(msg);
        }
        if (!(f = new File(this.pythonExecPath)).exists()) {
            boolean autodetected = !this.pythonCommandType.equals((Object)PYTHON_PATH);
            String msg = String.valueOf(autodetected ? "Autodetected" : "Specified") + " Python (at " + this.pythonExecPath + ") ";
            boolean isWinStore = this.pythonExecPath.contains("Microsoft\\WindowsApps");
            if (isWinStore) {
                msg = String.valueOf(msg) + "is from the Microsoft App store, but non-Microsoft programs do not have executable permissions; use a non-Microsoft version of Python.";
                msg = String.valueOf(msg) + "\nIf you have one installed, configure your user PATH or disable App store aliases to Python in your settings app.";
                msg = String.valueOf(msg) + "\nNote: If you modify the path variable, you may need to restart AnyLogic for the changes to take effect.";
            } else {
                msg = String.valueOf(msg) + "cannot be found or accessed.";
                msg = autodetected ? String.valueOf(msg) + " There may be a permissions issue or problem with the alias." : String.valueOf(msg) + " Check the path for typos or the permissions of the specified executable.";
            }
            this.error(msg);
        } else if (!f.isFile()) {
            File[] potentials = f.listFiles((dir, name) -> name.toLowerCase().equals("python.exe") || name.toLowerCase().equals("python"));
            if (potentials.length != 1) {
                String msg = "The specified path to the Python executable is not a file: " + this.pythonExecPath;
                msg = String.valueOf(msg) + "\nTried to find 'python.exe' or 'python', but couldn't locate a **single** result!";
                msg = String.valueOf(msg) + "\nPlease append the desired executable and try again.";
                this.error(msg);
            }
            this.set_pythonExecPath(potentials[0].getAbsolutePath());
        }
        try {
            this.py = new PySubProcess(pathToServerPy, this.pythonExecPath, this.redirectPyOutput, null);
            this.modifyPathAsNeeded();
        }
        catch (Exception e) {
            this.error(e, "Problem with setting up Python Subprocess");
        }
    }

    public static Attempt runFile(PythonCommandType preferredVersion, Object ... args) {
        ProcessBuilder pb = PyCommunicator.buildRunFileProcess(preferredVersion, args);
        String output = "";
        String error = "";
        try {
            Process proc = pb.start();
            output = IOUtils.toString((InputStream)proc.getInputStream()).trim();
            error = IOUtils.toString((InputStream)proc.getErrorStream()).trim();
        }
        catch (IOException | NullPointerException e) {
            String msg = String.format("Exception with running the command: `%s`\nStack trace is as follows:\n%s", String.join((CharSequence)" ", pb.command()), ExceptionUtils.toStringStackTrace((Throwable)e));
            return new Attempt(1, msg);
        }
        Attempt attempt = error.isEmpty() ? new Attempt(0, output) : new Attempt(1, error);
        return attempt;
    }

    public Attempt runFile(Object ... args) {
        Object[] tmp = new Object[args.length + 1];
        tmp[0] = this.py.activePyPath;
        System.arraycopy(args, 0, tmp, 1, args.length);
        Attempt attempt = PyCommunicator.runFile(PythonCommandType.PYTHON_PATH, tmp);
        this.history.add(0, (Pair<String, Attempt>)new Pair((Object)Arrays.toString(tmp), (Object)attempt));
        this.validateHistoryLimit();
        return attempt;
    }

    private void validateHistoryLimit() {
        while (this.history.size() > 500) {
            this.history.removeLast();
        }
    }

    void importProperties() {
        Properties prop = this.getSavedProperties();
        if (prop == null) {
            this.generateProperties();
        }
        this.set_enable(Boolean.valueOf(prop.getProperty("enable", "true")));
        this.set_loadLastWorkingConfig(Boolean.valueOf(prop.getProperty("load_last", "false")));
        this.set_pythonCommandType(PythonCommandType.valueOf(prop.getProperty("command_type")));
        this.set_pythonCommand(prop.getProperty("command"));
        this.set_pythonExecPath(prop.getProperty("exec_path"));
        this.set_throwErrorOnFailedAttempt(Boolean.valueOf(prop.getProperty("throw_error_on_failed_attempt")));
        this.set_redirectPyOutput(Boolean.valueOf(prop.getProperty("redirect_py_output", "true")));
        jsonFilter.setMode(Boolean.valueOf(prop.getProperty("json_blacklist_mode", "true")), false);
        jsonFilter.setAutogenerated(Boolean.valueOf(prop.getProperty("json_generated_option", "true")));
        jsonFilter.clearNames();
        jsonFilter.includeNames(prop.getProperty("json_name_filter", "").split(","));
        jsonFilter.clearClasses();
        String[] stringArray = prop.getProperty("json_class_filter", "").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String clz = stringArray[n2];
            try {
                jsonFilter.includeClasses(Class.forName(clz));
            }
            catch (ClassNotFoundException e) {
                this.warning("Class listed in filter but not found: %s", new Object[]{clz});
            }
            ++n2;
        }
        jsonFilter.clearPackages();
        jsonFilter.includePackages(prop.getProperty("json_package_filter", "").split(","));
    }

    void generateProperties() {
        String newFilePath = this.getDefaultPropertiesPath();
        try {
            FileOutputStream output = new FileOutputStream(newFilePath);
            Properties prop = new Properties();
            prop.setProperty("enable", String.valueOf(this.enable));
            prop.setProperty("load_last", String.valueOf(this.loadLastWorkingConfig));
            prop.setProperty("command_type", String.valueOf((Object)this.pythonCommandType));
            prop.setProperty("command", String.valueOf(this.pythonCommand));
            prop.setProperty("exec_path", String.valueOf(this.pythonExecPath));
            prop.setProperty("throw_error_on_failed_attempt", String.valueOf(this.throwErrorOnFailedAttempt));
            prop.setProperty("redirect_py_output", String.valueOf(this.redirectPyOutput));
            prop.setProperty("json_blacklist_mode", String.valueOf(jsonFilter.isInBlacklistMode()));
            prop.setProperty("json_generated_option", String.valueOf(jsonFilter.isAutogeneratedIncluded()));
            prop.setProperty("json_name_filter", jsonFilter.getIncludedNames().stream().collect(Collectors.joining(",")));
            prop.setProperty("json_class_filter", jsonFilter.getIncludedClasses().stream().map(s -> s.getName()).collect(Collectors.joining(",")));
            prop.setProperty("json_package_filter", jsonFilter.getIncludedPackages().stream().collect(Collectors.joining(",")));
            prop.store(output, null);
        }
        catch (FileNotFoundException fnf) {
            this.warning("The directory which Pypeline's jar file resides in does not have write access; properties file cannot be generated.");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public String getDefaultPropertiesPath() {
        String file = "pypeline.properties";
        try {
            URI parentURI = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI().resolve(".");
            String parentPath = Paths.get(parentURI).toString();
            file = Paths.get(parentPath, file).toString();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public <T> T runResults(Class<T> returnType, String code) {
        Attempt attempt = this.py.eval(code);
        this.history.add(0, (Pair<String, Attempt>)new Pair((Object)code, (Object)attempt));
        this.validateHistoryLimit();
        if (this.throwErrorOnFailedAttempt && !attempt.isSuccessful()) {
            this.error("Failed to run python code; feedback: %s", new Object[]{attempt.getFeedback()});
        }
        return attempt.getFeedback(returnType);
    }

    public static <T> T runFile(Class<T> returnType, PythonCommandType preferredVersion, Object ... args) {
        Attempt attempt = PyCommunicator.runFile(preferredVersion, args);
        return attempt.getFeedback(returnType);
    }

    public <T> T runFile(Class<T> returnType, Object ... args) {
        Attempt attempt = this.runFile(args);
        return attempt.getFeedback(returnType);
    }

    public <T> T runResults(Class<T> returnType, String ... lines) {
        String code = String.join((CharSequence)"\n", lines);
        return this.runResults(returnType, code);
    }

    void modifyPathAsNeeded() {
        File execFile = new File(this.pythonExecPath);
        File parentDir = execFile.getParentFile();
        String[] siblingFilenames = parentDir.list();
        boolean contains = Arrays.stream(siblingFilenames).anyMatch("conda-meta"::equals);
        if (contains) {
            this.run("import os");
            String pathStrs = "";
            String base = String.valueOf(parentDir.getAbsolutePath()) + File.separator;
            String[][] stringArray = condaPaths;
            int n = condaPaths.length;
            int n2 = 0;
            while (n2 < n) {
                CharSequence[] pathParts = stringArray[n2];
                pathStrs = String.valueOf(pathStrs) + base + String.join((CharSequence)File.separator, pathParts);
                pathStrs = String.valueOf(pathStrs) + File.pathSeparator;
                ++n2;
            }
            this.run(String.format("os.environ['PATH'] = r'%s' + os.environ['PATH']", pathStrs));
        }
    }

    public void connect() {
        this.initialize();
        this.generateProperties();
    }

    public void disconnect() {
        try {
            this.py.close();
            this.py = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.disconnect();
        this.connect();
    }

    public Attempt run(String codeFmt, Object ... args) {
        String code = String.format(codeFmt, args);
        return this.run(code);
    }

    public <T> T runResults(Class<T> returnType, String codeFmt, Object ... args) {
        String code = String.format(codeFmt, args);
        return this.runResults(returnType, code);
    }

    public Attempt runResults(String codeFmt, Object ... args) {
        String code = String.format(codeFmt, args);
        return this.runResults(code);
    }

    Properties getSavedProperties() {
        String filename = "pypeline.properties";
        File f = new File(filename);
        if (!f.exists()) {
            filename = this.getDefaultPropertiesPath();
        }
        if (!(f = new File(filename)).exists()) {
            return null;
        }
        Properties prop = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream input = new FileInputStream(filename);){
                prop = new Properties();
                prop.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.error(e, "Exception when reading properties file");
        }
        return prop;
    }

    public static FutureAttempt runFileHeadless(PythonCommandType preferredVersion, Object ... args) {
        Process proc;
        ProcessBuilder pb = PyCommunicator.buildRunFileProcess(preferredVersion, args);
        try {
            proc = pb.start();
        }
        catch (IOException | NullPointerException e) {
            String msg = String.format("Exception with running the command: `%s`\nStack trace is as follows:\n%s", String.join((CharSequence)" ", pb.command()), ExceptionUtils.toStringStackTrace((Throwable)e));
            return new FutureAttempt(new Attempt(1, msg));
        }
        FutureAttempt future = new FutureAttempt(proc);
        headlessAttempts.add(future);
        return future;
    }

    public FutureAttempt runFileHeadless(Object ... args) {
        Object[] tmp = new Object[args.length + 1];
        tmp[0] = this.py.activePyPath;
        System.arraycopy(args, 0, tmp, 1, args.length);
        FutureAttempt future = PyCommunicator.runFileHeadless(PythonCommandType.PYTHON_PATH, tmp);
        this.history.add(0, (Pair<String, Attempt>)new Pair((Object)Arrays.toString(tmp), (Object)future.get()));
        this.validateHistoryLimit();
        return future;
    }

    private static ProcessBuilder buildRunFileProcess(PythonCommandType preferredVersion, Object ... args) {
        try {
            String pyCmd = PySubProcess.convertToCommand(preferredVersion);
            if (preferredVersion.equals((Object)PythonCommandType.PYTHON_OTHER)) {
                pyCmd = args[0].toString();
                args[0] = PySubProcess.findPythonPath(pyCmd);
            } else if (!preferredVersion.equals((Object)PythonCommandType.PYTHON_PATH)) {
                String pyPath = PySubProcess.findPythonPath(pyCmd);
                Object[] tmp = new Object[args.length + 1];
                tmp[0] = pyPath;
                System.arraycopy(args, 0, tmp, 1, args.length);
                args = tmp;
            }
        }
        catch (PyException e) {
            throw new RuntimeException(String.format("Could not find Python path with version %s, args %s", new Object[]{preferredVersion, Arrays.toString(args)}));
        }
        String[] strArgs = (String[])Arrays.stream(args).map(a -> a.toString()).toArray(String[]::new);
        ProcessBuilder pb = new ProcessBuilder(strArgs);
        return pb;
    }

    private double _datasetUpdateTime_xjal() {
        return this.time();
    }

    @AnyLogicInternalCodegenAPI
    public int getViewAreas(Map<String, ViewArea> _output) {
        if (_output != null) {
            _output.put("_origin_VA", this._origin_VA);
        }
        return 1 + super.getViewAreas(_output);
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean isPublicPresentationDefined() {
        return super.isPublicPresentationDefined();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean isEmbeddedAgentPresentationVisible(Agent _a) {
        return super.isEmbeddedAgentPresentationVisible(_a);
    }

    @AnyLogicInternalCodegenAPI
    private void _initialize_level_xjal() {
        this.level.addAll(new LevelElement[]{this.text});
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public boolean onShapeClick(int _shape, int index, double clickx, double clicky) {
        switch (_shape) {
            case 8: {
                ShapeImage self = this.image2;
                return true;
            }
        }
        return super.onShapeClick(_shape, index, clickx, clicky);
    }

    @Override
    public Level[] getLevels() {
        return this._getLevels_xjal;
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsBP0_xjal() {
        this.image2 = new ShapeImage((Presentable)this, SHAPE_DRAW_2D, true, 5.0, 5.0, 0.0, 0.0, 32.0, 32.0, "/com/anylogic/libraries/pypeline/", new String[]{"Python-logo.png"}){
            @AnyLogicInternalCodegenAPI
            private static final long serialVersionUID = -6302081989069920764L;

            @AnyLogicInternalCodegenAPI
            public boolean onClick(double clickx, double clicky) {
                return PyCommunicator.this.onShapeClick(8, 0, clickx, clicky);
            }
        };
        this.text = new ShapeText(SHAPE_DRAW_2D, false, 40.0, 570.0, 0.0, 0.0, ColorConstants.gray, "GRAYED OBJECTS ARE INHERITED FROM THE JSONIFIER LIBRARY", _text_Font, ALIGNMENT_LEFT);
        this.text.setVisible(false);
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsAP0_xjal() {
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsBS0_xjal() {
    }

    private void instantiatePersistentElements_xjal() {
        this.level = new Level((Agent)this, "level", SHAPE_DRAW_2D3D, 0.0, true, true);
        this._getLevels_xjal = (Level[])UtilitiesArray.concatenateArrays((Object[])super.getLevels(), (Object[])new Level[]{this.level});
        this._createPersistentElementsBP0_xjal();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public ShapeTopLevelPresentationGroup getPresentationShape() {
        return this.presentation;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public ShapeModelElementsGroup getModelElementsShape() {
        return this.icon;
    }

    public PyCommunicator(Engine engine, Agent owner, AgentList<? extends PyCommunicator> ownerPopulation) {
        super(engine, owner, ownerPopulation);
        this.instantiateBaseStructureThis_xjal();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void onOwnerChanged_xjal() {
        super.onOwnerChanged_xjal();
        this.setupReferences_xjal();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void instantiateBaseStructure_xjal() {
        super.instantiateBaseStructure_xjal();
        this.instantiateBaseStructureThis_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void instantiateBaseStructureThis_xjal() {
        this.instantiatePersistentElements_xjal();
        this.setupReferences_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void setupReferences_xjal() {
    }

    public PyCommunicator() {
    }

    public PyCommunicator(boolean isBlacklistMode, boolean isCustomConfiguration, boolean includeAutogeneratedsBL, boolean includeAutogeneratedsWL, String[] includedPackagesBL, String[] includedPackagesWL, Class<?>[] includedClassesBL, Class<?>[] includedClassesWL, String[] includedNamesBL, String[] includedNamesWL, boolean enable, boolean loadLastWorkingConfig, PythonCommandType pythonCommandType, String pythonCommand, String pythonExecPath, boolean throwErrorOnFailedAttempt, boolean redirectPyOutput) {
        super(isBlacklistMode, isCustomConfiguration, includeAutogeneratedsBL, includeAutogeneratedsWL, includedPackagesBL, includedPackagesWL, includedClassesBL, includedClassesWL, includedNamesBL, includedNamesWL);
        this.enable = enable;
        this.loadLastWorkingConfig = loadLastWorkingConfig;
        this.pythonCommandType = pythonCommandType;
        this.pythonCommand = pythonCommand;
        this.pythonExecPath = pythonExecPath;
        this.throwErrorOnFailedAttempt = throwErrorOnFailedAttempt;
        this.redirectPyOutput = redirectPyOutput;
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void doCreate() {
        super.doCreate();
        this.setupPlainVariables_PyCommunicator_xjal();
        this._createPersistentElementsAP0_xjal();
        this._initialize_level_xjal();
        this.level.initialize();
        this.presentation.initialize_xjal(false, false, new Object[]{this.level});
        UtilitiesCollection.addAll(this.serverPyLines, (Object[])new String[]{"import os", "import socket", "import sys", "import json", "from json.decoder import JSONDecodeError", "import struct", "import traceback", "", "LEN_SIZE = 10", "TYPE_SIZE = 1", "", "# In", "EXEC_MSG = 0", "EVAL_MSG = 1", "PING_MSG = 2", "", "# Out", "SUCC_MSG = 0", "ERR_MSG = 1", "EMPTY_RESULT = ''", "", "def print_err(s):", "    sys.stderr.write('{}\\n'.format(s))", "    sys.stderr.flush()", "", "class ConnectionReader:", "    def __init__(self, conn):", "        self.conn = conn", "        self.buff = bytearray()", "", "    def _get_packet(self):", "        data = self.conn.recv(1024)", "        if not data:", "            raise EOFError('Connection closed')", "        return data", "", "    def read(self, size):", "        while len(self.buff) < size:", "            self.buff.extend(self._get_packet())", "        result = bytes(self.buff[:size])", "        del self.buff[:size]", "        return result", "", "    def read_json(self):", "        return json.loads(r'{}'.format(self.read_string()))", "", "    def read_int(self):", "        return struct.unpack('>i', self.read(4))[0]", "", "    def read_byte(self):", "        return struct.unpack('b', self.read(1))[0]", "", "    def read_string(self):", "        length = self.read_int()", "        bin_data = self.read(length)", "        try:", "            str_data = bin_data.decode(\"utf-8\")", "        except UnicodeDecodeError:", "            str_data = bin_data.decode(\"ISO-8859-1\")", "        return str_data", "", "", "class ConnectionWriter:", "    def __init__(self, conn):", "        self.conn = conn", "        self.buff = bytearray()", "", "    def write(self, data):", "        self.buff.extend(data)", "", "    def write_byte(self, b):", "        self.write(struct.pack('b', b))", "", "    def write_int(self, i):", "        self.write(struct.pack('>i', i))", "", "    def write_string(self, s):", "        bs = to_bytes(s)", "        self.write_int(len(bs))", "        self.write(bs)", "", "    def flush(self):", "        self.conn.sendall(self.buff)", "        self.clear()", "", "    def clear(self):", "        self.buff = bytearray()", "", "", "def utf8(bs):", "    if sys.version_info >= (3, 0):", "        return str(bs, 'UTF8')", "    return unicode(bs, 'UTF8')", "", "", "def to_bytes(s):", "    if type(s) == bytes:", "        return s", "", "    if type(s) != str:", "        s = str(s)", "", "    if sys.version_info >= (3, 0):", "        return bytes(s, 'UTF8')", "    return bytes(s)", "", "", "def responder():", "    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)", "    try:", "        sock.bind(('localhost', 0))", "        sock.listen(0)", "        _, port = sock.getsockname()", "        sys.stdout.write('{}\\n'.format(port))", "        sys.stdout.flush()", "        conn, addr = sock.accept()", "        try:", "            inp = ConnectionReader(conn)", "            out = ConnectionWriter(conn)", "            globs = {}", "            while True:", "                msg_type = int(inp.read_byte())", "                try:", "                    if msg_type == EXEC_MSG: # 0 (just run)", "                        code = inp.read_string()", "                        exec(code, globs)", "                        out.write_byte(SUCC_MSG)", "                        out.write_string(EMPTY_RESULT)", "                    elif msg_type == EVAL_MSG: # 1 (run and return)", "                        code = inp.read_string()", "                        try:", "                            result = eval(code, globs)", "                        except NameError as n_err: # assume json", "                            try:", "                                result = json.loads(r'{}'.format(code))", "                            except JSONDecodeError as j_err:", "                                raise Exception('The following line failed to parse (as strictly Python or JSON-parsed code):'", "                                                + '\\n    `{}`'.format(code)", "\t\t\t\t\t\t\t\t\t\t\t\t + '\\nConsider one of the following reasons:'", "                                                + '\\n1. Python reason: {}'.format(n_err)", "                                                + '\\n2. JSON   reason: {}'.format(j_err))", "                        out.write_byte(SUCC_MSG)", "                        out.write_string(result)", "                    elif msg_type == PING_MSG: # 2 (testing)", "                        out.write_byte(SUCC_MSG)", "                        out.write_string(EMPTY_RESULT)", "                    else:", "                        raise Exception('Unrecognized message type: {}'.format(msg_type))", "                except Exception as e:", "                    traceback.print_exc()", "                    out.write_byte(ERR_MSG)", "                    out.write_string(repr(e))", "                finally:", "                    out.flush()", "                    flush()", "        finally:", "            conn.close()", "    finally:", "        sock.close()", "", "def flush():", "    sys.stdout.flush()", "    sys.stderr.flush()", "", "if __name__ == '__main__':", "    sys.path.insert(0, os.getcwd())", "    responder()", ""});
        this.icon.initialize_xjal((ModelElementDescriptorUtils[])this.getElementProperty("com.anylogic.libraries.pypeline.PyCommunicator.icon", "modelElementDescriptors"), false, true, new Object[]{this.image2});
        this.icon.setIconOffsets(0.0, 0.0);
        this.setupInitialConditions_xjal(PyCommunicator.class);
        this._createPersistentElementsBS0_xjal();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void doStart() {
        super.doStart();
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void onStartup() {
        super.onStartup();
        if (this.enable) {
            this.connect();
        }
    }

    @Override
    @AnyLogicInternalCodegenAPI
    public void setupPlainVariables_xjal() {
        super.setupPlainVariables_xjal();
        this.setupPlainVariables_PyCommunicator_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void setupPlainVariables_PyCommunicator_xjal() {
        this.py = null;
    }

    public AgentList<? extends PyCommunicator> getPopulation() {
        return super.getPopulation();
    }

    public List<? extends PyCommunicator> agentsInRange(double distance) {
        return super.agentsInRange(distance);
    }

    @AnyLogicInternalCodegenAPI
    public void onDestroy() {
        try {
            headlessAttempts.forEach(a -> {
                boolean bl = a.cancel(true);
            });
            this.py.close();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    public PyCommunicator(boolean loadLastWorkingConfig) {
        this(true, loadLastWorkingConfig, PythonCommandType.PYTHON, null, null, true, true);
    }

    public PyCommunicator(PythonCommandType pythonCommandType) {
        this(true, false, pythonCommandType, null, null, true, true);
    }

    public PyCommunicator(PythonCommandType pythonCommandType, boolean throwErrorOnFailedAttempt, boolean redirectPyOutput) {
        this(true, false, pythonCommandType, "", "", throwErrorOnFailedAttempt, redirectPyOutput);
    }

    public PyCommunicator(PythonCommandType pythonCommandType, String otherCommandOrPath) {
        this(true, false, pythonCommandType, pythonCommandType.equals((Object)PYTHON_OTHER) ? otherCommandOrPath : null, pythonCommandType.equals((Object)PYTHON_PATH) ? otherCommandOrPath : null, true, true);
    }

    public PyCommunicator(PythonCommandType pythonCommandType, String otherCommandOrPath, boolean throwErrorOnFailedAttempt, boolean redirectPyOutput) {
        this(true, false, pythonCommandType, pythonCommandType.equals((Object)PYTHON_OTHER) ? otherCommandOrPath : null, pythonCommandType.equals((Object)PYTHON_PATH) ? otherCommandOrPath : null, throwErrorOnFailedAttempt, redirectPyOutput);
    }

    public PyCommunicator(boolean enable, boolean loadLast, PythonCommandType pythonCommandType, String otherCommandOrPath, String execPath, boolean throwError, boolean redirect) {
        this(true, true, true, false, null, null, null, null, null, null, enable, loadLast, pythonCommandType, otherCommandOrPath, execPath, throwError, redirect);
    }

    static HashMap<String, Object> serializeHistogram1DData(HistogramData h1data) {
        HashMap<String, Object> dataTable = new HashMap<String, Object>();
        int count = h1data.count();
        dataTable.put("count", count);
        dataTable.put("lowerBound", h1data.getXMin());
        dataTable.put("intervalWidth", h1data.getIntervalWidth());
        int[] hits = IntStream.range(0, h1data.getNumberOfIntervals()).map(i -> Math.round((float)h1data.getPDF(i) * (float)count)).toArray();
        dataTable.put("hits", hits);
        if (h1data instanceof HistogramSimpleData) {
            HistogramSimpleData hdataSimple = (HistogramSimpleData)h1data;
            dataTable.put("hitsOutLow", Math.round((float)hdataSimple.getPDFOutsideLow() * (float)count));
            dataTable.put("hitsOutHigh", Math.round((float)hdataSimple.getPDFOutsideHigh() * (float)count));
        }
        HashMap<String, Double> dtableStats = new HashMap<String, Double>();
        dtableStats.put("min", h1data.min());
        dtableStats.put("max", h1data.max());
        dtableStats.put("mean", h1data.mean());
        dtableStats.put("deviation", h1data.deviation());
        dataTable.put("statistics", dtableStats);
        return dataTable;
    }

    static HashMap<String, Object> serializeHistogram2DData(Histogram2DData h2data) {
        HashMap<String, Object> dataTable = new HashMap<String, Object>();
        int nX = h2data.getNumberOfXIntervals();
        int nY = h2data.getNumberOfYIntervals();
        int[][] hits = new int[nY][nX];
        int[] hitsOutLow = new int[nX];
        int[] hitsOutHigh = new int[nX];
        int x = 0;
        while (x < nX) {
            int xcount = h2data.count(x);
            hitsOutLow[x] = Math.round((float)h2data.getPDFOutsideLow(x) * (float)xcount);
            hitsOutHigh[x] = Math.round((float)h2data.getPDFOutsideHigh(x) * (float)xcount);
            int y = 0;
            while (y < nY) {
                hits[y][x] = Math.round((float)h2data.getPDF(x, y) * (float)xcount);
                ++y;
            }
            ++x;
        }
        dataTable.put("hits", hits);
        dataTable.put("hitsOutLow", hitsOutLow);
        dataTable.put("hitsOutHigh", hitsOutHigh);
        dataTable.put("xMin", h2data.getXMin());
        dataTable.put("xMax", h2data.getXMax());
        dataTable.put("yMin", h2data.getYMin());
        dataTable.put("yMax", h2data.getYMax());
        return dataTable;
    }

    static HashMap<String, Object> serializeStatisticsDiscrete(StatisticsDiscrete stat) {
        String[] statRows = stat.toString().split("\n");
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        Arrays.stream(statRows).map(s -> s.strip().split("\t")).forEach(s -> {
            Double d = statMap.put(s[0], Double.valueOf(s[1].replaceAll(",", "")));
        });
        return statMap;
    }

    static HashMap<String, Object> serializeStatisticsContinuous(StatisticsContinuous stat) {
        String[] statRows = stat.toString().split("\n");
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        Arrays.stream(statRows).map(s -> s.strip().split("\t")).forEach(s -> {
            Double d = statMap.put(s[0], Double.valueOf(s[1].replaceAll(",", "")));
        });
        return statMap;
    }

    private static enum ObjectAgentType {
        JAVA,
        AGENT_SINGLE,
        AGENT_POPULATION,
        AGENT_COLLECTION;

    }
}

