/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.engine.Utilities;
import com.anylogic.engine.presentation.ColorConstants;
import com.anylogic.libraries.pypeline.Attempt;
import com.anylogic.libraries.pypeline.PyException;
import com.anylogic.libraries.pypeline.PythonCommandType;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import spark.utils.IOUtils;

public class PySubProcess {
    public static final String findCmd = System.getProperty("os.name").toLowerCase().contains("win") ? "where" : "which";
    public String activePyPath = "";
    public String activePyVersion = "";
    public boolean redirectPyOutput;
    public static final byte execMsg = 0;
    public static final byte evalMsg = 1;
    public static final byte pingMsg = 2;
    public static final int successMsg = 0;
    public static final int errorMsg = 1;
    public Process proc = null;
    public Socket socket = null;
    public InputStream in = null;
    public OutputStream out = null;
    public InputStream stdout = null;
    public InputStream stderr = null;
    public ExecutorService executor = null;

    public PySubProcess(String pathToServerPy, String pathToPyExe, boolean redirectPyOutput, Level logLevel) throws IOException, PyException, InterruptedException {
        this.activePyPath = pathToPyExe;
        this.activePyVersion = PySubProcess.getPythonVersion(this.activePyPath);
        this.redirectPyOutput = redirectPyOutput;
        this.initConnection(pathToServerPy);
        this.openStreams();
    }

    private void initConnection(String pathToServerPy) throws IOException, PyException, InterruptedException {
        String serverPyFile = "server.py";
        File workingDirectory = new File(System.getProperty("user.dir"));
        if (pathToServerPy == null) {
            pathToServerPy = Paths.get(workingDirectory.toString(), "server.py").toString();
        } else if (!pathToServerPy.endsWith(".py")) {
            pathToServerPy = Paths.get(pathToServerPy, "server.py").toString();
        }
        if (!new File(pathToServerPy).exists()) {
            throw new IOException("Path to server python file does not exist: " + pathToServerPy);
        }
        List<String> pythonCmd = Arrays.asList(this.activePyPath, pathToServerPy);
        ProcessBuilder pb = new ProcessBuilder(PySubProcess.formatCommand(pythonCmd)).directory(workingDirectory);
        this.proc = pb.start();
        String portLine = null;
        BufferedReader pbInput = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
        portLine = pbInput.readLine();
        if (portLine == null) {
            String errorMsg = IOUtils.toString((InputStream)this.proc.getErrorStream());
            throw new IOException("Python process failed to properly start. This process needs to be started by a 'live' agent. Error message from process: '" + errorMsg + "'");
        }
        int port = Integer.MIN_VALUE;
        try {
            port = Integer.parseInt(portLine);
        }
        catch (NumberFormatException e) {
            this.earlyFail("Python process did not provide a port to connect with -- are you using a valid Python executable?; read line: " + portLine);
        }
        while (this.socket == null && this.proc.isAlive()) {
            try {
                this.socket = new Socket("localhost", port);
            }
            catch (IOException e) {
                Thread.sleep(100L);
            }
        }
        if (!this.proc.isAlive()) {
            this.earlyFail("Python process failed to start:");
        }
    }

    private void openStreams() {
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.stdout = this.proc.getInputStream();
            this.stderr = this.proc.getErrorStream();
            this.executor = Executors.newSingleThreadExecutor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void earlyFail(String prefix) throws IOException, PyException {
        String stdoutOutput = PySubProcess.readAllReady(new InputStreamReader(this.proc.getInputStream()));
        String stderrOutput = PySubProcess.readAllReady(new InputStreamReader(this.proc.getErrorStream()));
        throw new PyException("[ERROR] " + prefix + (prefix.endsWith("\n") ? "" : "\n") + (stderrOutput.isEmpty() ? "" : "Error stream message:\n" + stderrOutput) + (stdoutOutput.isEmpty() ? "" : "Output stream message:\n" + stdoutOutput));
    }

    public Attempt ping() {
        Attempt outcome = null;
        if (this.socket.isClosed()) {
            outcome = new Attempt(1, "Python subprocess has been shutdown.");
        } else {
            try {
                this.out.write(2);
                this.out.flush();
                outcome = this.readAttemptResult();
            }
            catch (Throwable e) {
                outcome = new Attempt(e);
            }
        }
        return outcome;
    }

    public Attempt exec(String stmt) {
        Attempt outcome = null;
        try {
            this.out.write(0);
            this.writeString(stmt);
            this.out.flush();
            outcome = this.readAttemptResult();
        }
        catch (Throwable e) {
            outcome = new Attempt(e);
        }
        return outcome;
    }

    public Attempt eval(String expr) {
        Attempt outcome = null;
        try {
            this.out.write(1);
            this.writeString(expr);
            this.out.flush();
            outcome = this.readAttemptResult();
        }
        catch (Exception e) {
            outcome = new Attempt(e);
        }
        return outcome;
    }

    private Attempt readAttemptResult() throws IOException {
        while (this.in.available() == 0) {
            this.printStdout();
            this.printStderr();
        }
        byte resultCode = this.readByte();
        String feedback = this.readString();
        this.printStdout();
        this.printStderr();
        Attempt outcome = new Attempt(resultCode, feedback);
        return outcome;
    }

    private void printStdout() throws IOException {
        int n = this.stdout.available();
        if (n > 0) {
            byte[] b = new byte[n];
            this.stdout.read(b);
            String s = new String(b).trim();
            s = "> " + s.replaceAll("(\\r\\n|\\r|\\n)", "$1> ");
            if (this.redirectPyOutput) {
                Utilities.traceln((Color)ColorConstants.green, (Object)s);
            }
        }
    }

    private void printStderr() throws IOException {
        int n = this.stderr.available();
        if (n > 0) {
            byte[] b = new byte[n];
            this.stderr.read(b);
            String s = new String(b).trim();
            s = "> " + s.replaceAll("(\\r\\n|\\r|\\n)", "$1> ");
            if (this.redirectPyOutput) {
                Utilities.traceln((Color)ColorConstants.red, (Object)s);
            }
        }
    }

    byte[] read(int numBytes) throws IOException {
        byte[] output = new byte[numBytes];
        int i = 0;
        while (i < numBytes) {
            output[i] = this.readByte();
            ++i;
        }
        return output;
    }

    byte readByte() throws IOException {
        int nextByte = this.in.read();
        if (nextByte == -1) {
            throw new IOException("Cannot read byte; reached end of stream");
        }
        return (byte)nextByte;
    }

    int readInt() throws IOException {
        return this.readByte() << 24 & 0xFF000000 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() << 0 & 0xFF;
    }

    String readString() throws IOException {
        int len = this.readInt();
        String output = new String(this.read(len), "UTF-8");
        return output;
    }

    void writeInt(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        this.out.write(b);
    }

    void writeString(String str) throws IOException {
        byte[] b = str.getBytes();
        this.writeInt(b.length);
        this.out.write(b);
    }

    void close() throws Exception {
        this.executor.shutdownNow();
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.proc.destroyForcibly();
        try {
            this.proc.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.proc.isAlive()) {
            throw new Exception("Python process failed to shutdown. Please shut it down via your process manager");
        }
    }

    public static List<String> formatCommand(List<String> args) {
        String os = System.getProperty("os.name").toLowerCase();
        return args;
    }

    public static String readAllReady(InputStream in) throws IOException {
        return PySubProcess.readAllReady(new InputStreamReader(in));
    }

    public static String readAllReady(InputStreamReader inReader) throws IOException {
        StringBuilder sbuilder = new StringBuilder();
        while (inReader.ready()) {
            sbuilder.append((char)inReader.read());
        }
        return sbuilder.toString();
    }

    public static String convertToCommand(PythonCommandType preferredCommand) {
        switch (preferredCommand) {
            case PYTHON: {
                return "python";
            }
            case PYTHON2: {
                return "python2";
            }
            case PYTHON3: {
                return "python3";
            }
        }
        return null;
    }

    public static String findPythonPath(String pythonCommand) throws PyException {
        ProcessBuilder pb = new ProcessBuilder(findCmd, pythonCommand);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        String loc = null;
        try {
            Process proc = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            loc = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e2) {
            throw new PyException("Failed to find Python path using command: " + pythonCommand);
        }
        return loc;
    }

    public static String getPythonVersion(String pythonPath) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(pythonPath, "--version");
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        Process proc = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String version = reader.readLine();
        if (version == null) {
            version = new BufferedReader(new InputStreamReader(proc.getErrorStream())).readLine();
        }
        return version;
    }
}

