/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.libraries.pypeline;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.EventOriginator;
import com.anylogic.engine.FlowchartBlock;
import com.anylogic.engine.FlowchartMappedPort;
import com.anylogic.engine.LinkToAgentStandardImpl;
import com.anylogic.engine.Position;
import com.anylogic.engine.Statechart;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.analysis.Histogram2DData;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.HistogramSimpleData;
import com.anylogic.engine.analysis.StatisticsContinuous;
import com.anylogic.engine.analysis.StatisticsDiscrete;
import com.anylogic.engine.markup.AbstractMarkup;
import com.anylogic.engine.markup.AbstractMarkupAggregator;
import com.anylogic.engine.markup.AnimationStaticLocationProvider;
import com.anylogic.engine.presentation.Shape;
import com.anylogic.engine.presentation.Shape3D;
import com.anylogic.engine.presentation.ViewArea;
import com.anylogic.libraries.pypeline.Jsonifier;
import com.anylogic.libraries.pypeline.PyCommunicator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.PrimaryKey;
import com.querydsl.sql.RelationalPathBase;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Serializers {
    public static void register(ObjectMapper mapper, Class<?> ... serClasses) {
        SimpleModule module = new SimpleModule();
        Class<?>[] classArray = serClasses;
        int n = serClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            try {
                ACustomSerializer s = (ACustomSerializer)((Object)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                module.addSerializer(s.handledType(), (JsonSerializer)s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        mapper.registerModule((Module)module);
    }

    public static abstract class ACustomSerializer<T>
    extends StdSerializer<T> {
        public ACustomSerializer() {
            this(null);
        }

        public ACustomSerializer(Class<T> t) {
            super(t);
        }

        public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;
    }

    public static class AbstractMarkupAggregatorSerializer
    extends ACustomSerializer<AbstractMarkupAggregator> {
        public AbstractMarkupAggregatorSerializer() {
            super(AbstractMarkupAggregator.class);
        }

        @Override
        public void serialize(AbstractMarkupAggregator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNull();
        }
    }

    public static class AbstractMarkupSerializer
    extends ACustomSerializer<AbstractMarkup> {
        public AbstractMarkupSerializer() {
            super(AbstractMarkup.class);
        }

        @Override
        public void serialize(AbstractMarkup value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value instanceof AnimationStaticLocationProvider) {
                jgen.writeStartObject();
                AnimationStaticLocationProvider providerValue = (AnimationStaticLocationProvider)value;
                Position pos = providerValue.getPosition(0, 5, null);
                jgen.writeObjectField("position", (Object)pos);
                jgen.writeObjectField("space_type", (Object)providerValue.getSpace().getAgentSpaceType().formatName());
                jgen.writeEndObject();
            } else {
                jgen.writeNull();
            }
        }
    }

    public static class AgentListSerializer
    extends ACustomSerializer<AgentList> {
        public AgentListSerializer() {
            super(AgentList.class);
        }

        @Override
        public void serialize(AgentList value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            int i = 0;
            while (i < value.size()) {
                jgen.writeObject((Object)value.get(i));
                ++i;
            }
            jgen.writeEndArray();
        }
    }

    public static class AgentSerializer
    extends ACustomSerializer<Agent> {
        public AgentSerializer() {
            super(Agent.class);
        }

        @Override
        public void serialize(Agent value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            HashMap<String, Object> map = Jsonifier.agentToMap(value, true, null);
            for (String key : new TreeSet<String>(map.keySet())) {
                Object val = map.get(key);
                jgen.writeObjectField(key, val);
            }
            jgen.writeEndObject();
        }
    }

    public static class DataSetSerializer
    extends ACustomSerializer<DataSet> {
        public DataSetSerializer() {
            super(DataSet.class);
        }

        @Override
        public void serialize(DataSet value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeNumberField("xmin", value.getXMin());
            jgen.writeNumberField("xmean", value.getXMean());
            jgen.writeNumberField("xmedian", value.getXMedian());
            jgen.writeNumberField("xmax", value.getXMax());
            jgen.writeNumberField("ymin", value.getYMin());
            jgen.writeNumberField("ymean", value.getYMean());
            jgen.writeNumberField("ymedian", value.getYMedian());
            jgen.writeNumberField("ymax", value.getYMax());
            ArrayList values = new ArrayList();
            IntStream.range(0, value.size()).forEach(i -> {
                boolean bl = values.add(new double[]{value.getX(i), value.getY(i)});
            });
            jgen.writeObjectField("plainDataTable", (Object)value.getPlainDataTable());
            jgen.writeEndObject();
        }
    }

    public static class DatabaseConnectionSerializer
    extends ACustomSerializer<Connection> {
        public DatabaseConnectionSerializer() {
            super(Connection.class);
        }

        @Override
        public void serialize(Connection value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            try {
                jgen.writeStartArray();
                DatabaseMetaData metadata = value.getMetaData();
                ResultSet tables = metadata.getTables(null, null, null, new String[]{"TABLE"});
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    ArrayList columns = new ArrayList();
                    ResultSet columnsResultSet = metadata.getColumns(null, null, tableName, null);
                    while (columnsResultSet.next()) {
                        LinkedHashMap<String, String> columnInfo = new LinkedHashMap<String, String>();
                        columnInfo.put("column_name", columnsResultSet.getString("COLUMN_NAME"));
                        columnInfo.put("column_type", columnsResultSet.getString("TYPE_NAME"));
                        columns.add(columnInfo);
                    }
                    Map constraints = Map.of("primary_keys", new ArrayList(), "foreign_keys", new ArrayList());
                    ResultSet primaryKeysResultSet = metadata.getPrimaryKeys(null, null, tableName);
                    while (primaryKeysResultSet.next()) {
                        LinkedHashMap<String, String> primaryKeyInfo = new LinkedHashMap<String, String>();
                        primaryKeyInfo.put("column_name", primaryKeysResultSet.getString("COLUMN_NAME"));
                        ((List)constraints.get("primary_keys")).add(primaryKeyInfo);
                    }
                    ResultSet foreignKeysResultSet = metadata.getImportedKeys(null, null, tableName);
                    while (foreignKeysResultSet.next()) {
                        LinkedHashMap<String, String> foreignKeyInfo = new LinkedHashMap<String, String>();
                        foreignKeyInfo.put("column_name", foreignKeysResultSet.getString("FKCOLUMN_NAME"));
                        foreignKeyInfo.put("referenced_table_name", foreignKeysResultSet.getString("PKTABLE_NAME"));
                        foreignKeyInfo.put("referenced_column_name", foreignKeysResultSet.getString("PKCOLUMN_NAME"));
                        ((List)constraints.get("foreign_keys")).add(foreignKeyInfo);
                    }
                    ArrayList data = new ArrayList();
                    Statement statement = value.createStatement();
                    String columnCSV = columns.stream().map(c -> (String)c.get("column_name")).collect(Collectors.joining(","));
                    ResultSet resultSet = statement.executeQuery("SELECT " + columnCSV + " FROM " + tableName);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int columnCount = resultSetMetaData.getColumnCount();
                    while (resultSet.next()) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        int i = 1;
                        while (i <= columnCount) {
                            row.add(resultSet.getObject(i));
                            ++i;
                        }
                        data.add(row);
                    }
                    jgen.writeStartObject();
                    jgen.writeStringField("table_name", tableName);
                    jgen.writeObjectField("columns", columns);
                    jgen.writeObjectField("constraints", constraints);
                    jgen.writeObjectField("data", data);
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
            }
            catch (SQLException e) {
                jgen.writeNull();
            }
        }
    }

    public static class EventOriginatorSerializer
    extends ACustomSerializer<EventOriginator> {
        public EventOriginatorSerializer() {
            super(EventOriginator.class);
        }

        @Override
        public void serialize(EventOriginator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeNumberField("time_remaining", value.getRest());
            jgen.writeEndObject();
        }
    }

    public static class FlowchartBlockSerializer
    extends ACustomSerializer<FlowchartBlock> {
        public FlowchartBlockSerializer() {
            super(FlowchartBlock.class);
        }

        @Override
        public void serialize(FlowchartBlock value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("type", value.getClass().getSimpleName().isEmpty() ? Pattern.compile("[^:]+:\\s*(.*?)\\s.+", 32).matcher(value.toString()).replaceFirst("$1") : value.getClass().getSimpleName());
            jgen.writeObjectField("parameters", (Object)Arrays.stream(value.getParameterNames()).collect(HashMap::new, (map, name) -> {
                Object object = map.put(name, value.getParameter(name));
            }, HashMap::putAll));
            jgen.writeObjectField("ports", Arrays.stream(value.getClass().getFields()).filter(f -> !f.getName().endsWith("_xjal") && f.getType().isAssignableFrom(FlowchartMappedPort.class)).collect(Collectors.toMap(f -> f.getName(), f -> {
                try {
                    return ((FlowchartMappedPort)f.get(value)).count();
                }
                catch (Exception e) {
                    return -1;
                }
            })));
            jgen.writeEndObject();
        }
    }

    public static class Histogram1DSerializer
    extends ACustomSerializer<HistogramData> {
        public Histogram1DSerializer() {
            super(HistogramData.class);
        }

        @Override
        public void serialize(HistogramData value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            int count = value.count();
            jgen.writeNumberField("count", count);
            jgen.writeNumberField("lowerBound", value.getXMin());
            jgen.writeNumberField("intervalWidth", value.getIntervalWidth());
            int[] hits = IntStream.range(0, value.getNumberOfIntervals()).map(i -> Math.round((float)value.getPDF(i) * (float)count)).toArray();
            jgen.writeObjectField("hits", (Object)hits);
            if (value instanceof HistogramSimpleData) {
                HistogramSimpleData hdataSimple = (HistogramSimpleData)value;
                jgen.writeNumberField("hitsOutLow", Math.round((float)hdataSimple.getPDFOutsideLow() * (float)count));
                jgen.writeNumberField("hitsOutHigh", Math.round((float)hdataSimple.getPDFOutsideHigh() * (float)count));
            }
            HashMap<String, Double> dtableStats = new HashMap<String, Double>();
            dtableStats.put("min", value.min());
            dtableStats.put("max", value.max());
            dtableStats.put("mean", value.mean());
            dtableStats.put("deviation", value.deviation());
            jgen.writeObjectField("statistics", dtableStats);
            jgen.writeEndObject();
        }
    }

    public static class Histogram2DSerializer
    extends ACustomSerializer<Histogram2DData> {
        public Histogram2DSerializer() {
            super(Histogram2DData.class);
        }

        @Override
        public void serialize(Histogram2DData value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            int nX = value.getNumberOfXIntervals();
            int nY = value.getNumberOfYIntervals();
            int[][] hits = new int[nY][nX];
            int[] hitsOutLow = new int[nX];
            int[] hitsOutHigh = new int[nX];
            int x = 0;
            while (x < nX) {
                int xcount = value.count(x);
                hitsOutLow[x] = Math.round((float)value.getPDFOutsideLow(x) * (float)xcount);
                hitsOutHigh[x] = Math.round((float)value.getPDFOutsideHigh(x) * (float)xcount);
                int y = 0;
                while (y < nY) {
                    hits[y][x] = Math.round((float)value.getPDF(x, y) * (float)xcount);
                    ++y;
                }
                ++x;
            }
            jgen.writeObjectField("hits", (Object)hits);
            jgen.writeObjectField("hitsOutLow", (Object)hitsOutLow);
            jgen.writeObjectField("hitsOutHigh", (Object)hitsOutHigh);
            jgen.writeNumberField("xMin", value.getXMin());
            jgen.writeNumberField("xMax", value.getXMax());
            jgen.writeNumberField("yMin", value.getYMin());
            jgen.writeNumberField("yMax", value.getYMax());
            jgen.writeEndObject();
        }
    }

    public static class LinkToAgentsSerializer
    extends ACustomSerializer<LinkToAgentStandardImpl> {
        public LinkToAgentsSerializer() {
            super(LinkToAgentStandardImpl.class);
        }

        @Override
        public void serialize(LinkToAgentStandardImpl value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("owner", value.getOwner().getName());
            jgen.writeNumberField("connections_count", value.getConnectionsNumber());
            jgen.writeEndObject();
        }
    }

    public static class Shape3DSerializer
    extends ACustomSerializer<Shape3D> {
        public Shape3DSerializer() {
            super(Shape3D.class);
        }

        @Override
        public void serialize(Shape3D value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart("position");
            jgen.writeNumberField("x", value.getX());
            jgen.writeNumberField("y", value.getY());
            jgen.writeNumberField("z", value.getZ());
            jgen.writeNumberField("rotation", value.getRotation());
            jgen.writeEndObject();
            jgen.writeObjectFieldStart("scale");
            jgen.writeNumberField("x", value.getScaleX());
            jgen.writeNumberField("y", value.getScaleY());
            jgen.writeNumberField("z", value.getScaleZ());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    public static class ShapeSerializer
    extends ACustomSerializer<Shape> {
        public ShapeSerializer() {
            super(Shape.class);
        }

        @Override
        public void serialize(Shape value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart("position");
            jgen.writeNumberField("x", value.getX());
            jgen.writeNumberField("y", value.getY());
            jgen.writeEndObject();
            jgen.writeObjectFieldStart("scale");
            jgen.writeNumberField("x", value.getScaleX());
            jgen.writeNumberField("y", value.getScaleY());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    public static class StatechartSerializer
    extends ACustomSerializer<Statechart> {
        public StatechartSerializer() {
            super(Statechart.class);
        }

        @Override
        public void serialize(Statechart value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectField("active_state", Map.of("full", value.getFullState(), "simple", value.getActiveSimpleState().name()));
            jgen.writeEndObject();
        }
    }

    public static class StatisticsContinuousSerializer
    extends ACustomSerializer<StatisticsContinuous> {
        public StatisticsContinuousSerializer() {
            super(StatisticsContinuous.class);
        }

        @Override
        public void serialize(StatisticsContinuous value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            String[] statRows = value.toString().split("\n");
            Arrays.stream(statRows).map(s -> s.strip().split("\t")).forEach(s -> {
                try {
                    jgen.writeNumberField(s[0], Double.valueOf(s[1].replaceAll(",", "")).doubleValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            jgen.writeEndObject();
        }
    }

    public static class StatisticsDiscreteSerializer
    extends ACustomSerializer<StatisticsDiscrete> {
        public StatisticsDiscreteSerializer() {
            super(StatisticsDiscrete.class);
        }

        @Override
        public void serialize(StatisticsDiscrete value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            String[] statRows = value.toString().split("\n");
            Arrays.stream(statRows).map(s -> s.strip().split("\t")).forEach(s -> {
                try {
                    jgen.writeNumberField(s[0], Double.valueOf(s[1].replaceAll(",", "")).doubleValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            jgen.writeEndObject();
        }
    }

    public static class TableSerializer
    extends ACustomSerializer<RelationalPathBase> {
        public TableSerializer() {
            super(RelationalPathBase.class);
        }

        @Override
        public void serialize(RelationalPathBase value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String tableName = value.getTableName();
            ArrayList<LinkedHashMap<String, String>> columns = new ArrayList<LinkedHashMap<String, String>>();
            ArrayList<LinkedHashMap<String, String>> primaryKeys = new ArrayList<LinkedHashMap<String, String>>();
            ArrayList foreignKeys = new ArrayList();
            for (Object colObj : value.getColumns()) {
                Path col = (Path)colObj;
                columns.add(new LinkedHashMap<String, String>(Map.of("column_name", col.getMetadata().getName(), "column_type", col.getType().getName())));
            }
            PrimaryKey primaryKey = value.getPrimaryKey();
            if (primaryKey != null) {
                for (Expression expression : primaryKey.getLocalColumns()) {
                    primaryKeys.add(new LinkedHashMap<String, String>(Map.of("column_name", ((Path)expression).getMetadata().getName())));
                }
            }
            for (Object foreignKeyObj : value.getForeignKeys()) {
                ForeignKey foreignKey = (ForeignKey)foreignKeyObj;
                HashMap foreignKeyInfo = new HashMap();
                ArrayList<String> foreignKeyColumns = new ArrayList<String>();
                ArrayList<String> referencedColumns = new ArrayList<String>();
                for (Expression localColumn : foreignKey.getLocalColumns()) {
                    foreignKeyColumns.add(((Path)localColumn).getMetadata().getName());
                }
                for (String referencedColumn : foreignKey.getForeignColumns()) {
                    referencedColumns.add(referencedColumn);
                }
                foreignKeyInfo.put("column_names", foreignKeyColumns);
                foreignKeyInfo.put("referenced_column_names", referencedColumns);
                foreignKeys.add(foreignKeyInfo);
            }
            jgen.writeStartObject();
            jgen.writeStringField("table_name", tableName);
            jgen.writeObjectField("columns", columns);
            jgen.writeObjectField("constraints", new LinkedHashMap(Map.of("primary_keys", primaryKeys, "foreign_keys", foreignKeys)));
            if (PyCommunicator.root != null) {
                ArrayList data = new ArrayList();
                try {
                    Statement statement = PyCommunicator.root.getDatabaseConnection().createStatement();
                    String columnCSV = columns.stream().map(c -> (String)c.get("column_name")).collect(Collectors.joining(","));
                    ResultSet resultSet = statement.executeQuery("SELECT " + columnCSV + " FROM " + tableName);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int columnCount = resultSetMetaData.getColumnCount();
                    while (resultSet.next()) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        int i = 1;
                        while (i <= columnCount) {
                            row.add(resultSet.getObject(i));
                            ++i;
                        }
                        data.add(row);
                    }
                    jgen.writeObjectField("data", data);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            jgen.writeEndObject();
        }
    }

    public static class TupleSerializer
    extends ACustomSerializer<Tuple> {
        public TupleSerializer() {
            super(Tuple.class);
        }

        @Override
        public void serialize(Tuple value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            Object[] objectArray = value.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                jgen.writeObject(obj);
                ++n2;
            }
            jgen.writeEndArray();
        }
    }

    public static class ViewAreaSerializer
    extends ACustomSerializer<ViewArea> {
        public ViewAreaSerializer() {
            super(ViewArea.class);
        }

        @Override
        public void serialize(ViewArea value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNull();
        }
    }
}

