/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.NodeInfo;
import ai.onnxruntime.OnnxModelMetadata;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.providers.CoreMLFlags;
import ai.onnxruntime.providers.NNAPIFlags;
import ai.onnxruntime.providers.OrtFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public class OrtSession
implements AutoCloseable {
    private final long nativeHandle;
    private final OrtAllocator allocator;
    private final long numInputs;
    private final Set<String> inputNames;
    private final long numOutputs;
    private final Set<String> outputNames;
    private OnnxModelMetadata metadata;
    private boolean closed = false;

    OrtSession(OrtEnvironment env, String modelPath, OrtAllocator allocator, SessionOptions options) throws OrtException {
        this(OrtSession.createSession(OnnxRuntime.ortApiHandle, env.nativeHandle, modelPath, options.nativeHandle), allocator);
    }

    OrtSession(OrtEnvironment env, byte[] modelArray, OrtAllocator allocator, SessionOptions options) throws OrtException {
        this(OrtSession.createSession(OnnxRuntime.ortApiHandle, env.nativeHandle, modelArray, options.nativeHandle), allocator);
    }

    private OrtSession(long nativeHandle, OrtAllocator allocator) throws OrtException {
        this.nativeHandle = nativeHandle;
        this.allocator = allocator;
        this.numInputs = this.getNumInputs(OnnxRuntime.ortApiHandle, nativeHandle);
        this.inputNames = new LinkedHashSet<String>(Arrays.asList(this.getInputNames(OnnxRuntime.ortApiHandle, nativeHandle, allocator.handle)));
        this.numOutputs = this.getNumOutputs(OnnxRuntime.ortApiHandle, nativeHandle);
        this.outputNames = new LinkedHashSet<String>(Arrays.asList(this.getOutputNames(OnnxRuntime.ortApiHandle, nativeHandle, allocator.handle)));
    }

    public long getNumInputs() {
        if (!this.closed) {
            return this.numInputs;
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public long getNumOutputs() {
        if (!this.closed) {
            return this.numOutputs;
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Set<String> getInputNames() {
        if (!this.closed) {
            return this.inputNames;
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public Set<String> getOutputNames() {
        if (!this.closed) {
            return this.outputNames;
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Map<String, NodeInfo> getInputInfo() throws OrtException {
        if (!this.closed) {
            return OrtSession.wrapInMap(this.getInputInfo(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle));
        }
        throw new IllegalStateException("Asking for inputs from a closed OrtSession.");
    }

    public Map<String, NodeInfo> getOutputInfo() throws OrtException {
        if (!this.closed) {
            return OrtSession.wrapInMap(this.getOutputInfo(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle));
        }
        throw new IllegalStateException("Asking for outputs from a closed OrtSession.");
    }

    public Result run(Map<String, OnnxTensor> inputs) throws OrtException {
        return this.run(inputs, this.outputNames);
    }

    public Result run(Map<String, OnnxTensor> inputs, RunOptions runOptions) throws OrtException {
        return this.run(inputs, this.outputNames, runOptions);
    }

    public Result run(Map<String, OnnxTensor> inputs, Set<String> requestedOutputs) throws OrtException {
        return this.run(inputs, requestedOutputs, null);
    }

    public Result run(Map<String, OnnxTensor> inputs, Set<String> requestedOutputs, RunOptions runOptions) throws OrtException {
        if (!this.closed) {
            if (inputs.isEmpty() || (long)inputs.size() > this.numInputs) {
                throw new OrtException("Unexpected number of inputs, expected [1," + this.numInputs + ") found " + inputs.size());
            }
            if (requestedOutputs.isEmpty() || (long)requestedOutputs.size() > this.numOutputs) {
                throw new OrtException("Unexpected number of requestedOutputs, expected [1," + this.numOutputs + ") found " + requestedOutputs.size());
            }
            String[] inputNamesArray = new String[inputs.size()];
            long[] inputHandles = new long[inputs.size()];
            int i = 0;
            for (Map.Entry<String, OnnxTensor> t : inputs.entrySet()) {
                if (this.inputNames.contains(t.getKey())) {
                    inputNamesArray[i] = (String)t.getKey();
                    inputHandles[i] = ((OnnxTensor)t.getValue()).getNativeHandle();
                    ++i;
                    continue;
                }
                throw new OrtException("Unknown input name " + (String)t.getKey() + ", expected one of " + this.inputNames.toString());
            }
            String[] outputNamesArray = new String[requestedOutputs.size()];
            i = 0;
            for (String s : requestedOutputs) {
                if (this.outputNames.contains(s)) {
                    outputNamesArray[i] = s;
                    ++i;
                    continue;
                }
                throw new OrtException("Unknown output name " + s + ", expected one of " + this.outputNames.toString());
            }
            long runOptionsHandle = runOptions == null ? 0L : runOptions.nativeHandle;
            OnnxValue[] outputValues = this.run(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle, inputNamesArray, inputHandles, inputNamesArray.length, outputNamesArray, outputNamesArray.length, runOptionsHandle);
            return new Result(outputNamesArray, outputValues);
        }
        throw new IllegalStateException("Trying to score a closed OrtSession.");
    }

    public OnnxModelMetadata getMetadata() throws OrtException {
        if (this.metadata == null) {
            this.metadata = this.constructMetadata(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle);
        }
        return this.metadata;
    }

    public long getProfilingStartTimeInNs() throws OrtException {
        return this.getProfilingStartTimeInNs(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    public String endProfiling() throws OrtException {
        return this.endProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocator.handle);
    }

    public String toString() {
        return "OrtSession(numInputs=" + this.numInputs + ",numOutputs=" + this.numOutputs + ")";
    }

    @Override
    public void close() throws OrtException {
        if (this.closed) {
            throw new IllegalStateException("Trying to close an already closed OrtSession.");
        }
        this.closeSession(OnnxRuntime.ortApiHandle, this.nativeHandle);
        this.closed = true;
    }

    private static Map<String, NodeInfo> wrapInMap(NodeInfo[] infos) {
        LinkedHashMap<String, NodeInfo> output = new LinkedHashMap<String, NodeInfo>();
        for (NodeInfo info : infos) {
            output.put(info.getName(), info);
        }
        return output;
    }

    private static native long createSession(long var0, long var2, String var4, long var5) throws OrtException;

    private static native long createSession(long var0, long var2, byte[] var4, long var5) throws OrtException;

    private native long getNumInputs(long var1, long var3) throws OrtException;

    private native String[] getInputNames(long var1, long var3, long var5) throws OrtException;

    private native NodeInfo[] getInputInfo(long var1, long var3, long var5) throws OrtException;

    private native long getNumOutputs(long var1, long var3) throws OrtException;

    private native String[] getOutputNames(long var1, long var3, long var5) throws OrtException;

    private native NodeInfo[] getOutputInfo(long var1, long var3, long var5) throws OrtException;

    private native OnnxValue[] run(long var1, long var3, long var5, String[] var7, long[] var8, long var9, String[] var11, long var12, long var14) throws OrtException;

    private native long getProfilingStartTimeInNs(long var1, long var3) throws OrtException;

    private native String endProfiling(long var1, long var3, long var5) throws OrtException;

    private native void closeSession(long var1, long var3) throws OrtException;

    private native OnnxModelMetadata constructMetadata(long var1, long var3, long var5) throws OrtException;

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }

    public static class Result
    implements AutoCloseable,
    Iterable<Map.Entry<String, OnnxValue>> {
        private static final Logger logger = Logger.getLogger(Result.class.getName());
        private final Map<String, OnnxValue> map = new LinkedHashMap<String, OnnxValue>();
        private final List<OnnxValue> list = new ArrayList<OnnxValue>();
        private boolean closed;

        Result(String[] names, OnnxValue[] values) {
            if (names.length != values.length) {
                throw new IllegalArgumentException("Expected same number of names and values, found names.length = " + names.length + ", values.length = " + values.length);
            }
            for (int i = 0; i < names.length; ++i) {
                this.map.put(names[i], values[i]);
                this.list.add(values[i]);
            }
            this.closed = false;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                for (OnnxValue t : this.map.values()) {
                    t.close();
                }
            } else {
                logger.warning("Closing an already closed Result");
            }
        }

        @Override
        public Iterator<Map.Entry<String, OnnxValue>> iterator() {
            if (!this.closed) {
                return this.map.entrySet().iterator();
            }
            throw new IllegalStateException("Result is closed");
        }

        public OnnxValue get(int index) {
            if (!this.closed) {
                return this.list.get(index);
            }
            throw new IllegalStateException("Result is closed");
        }

        public int size() {
            return this.map.size();
        }

        public Optional<OnnxValue> get(String key) {
            if (!this.closed) {
                OnnxValue value = this.map.get(key);
                if (value != null) {
                    return Optional.of(value);
                }
                return Optional.empty();
            }
            throw new IllegalStateException("Result is closed");
        }
    }

    public static class RunOptions
    implements AutoCloseable {
        private final long nativeHandle = RunOptions.createRunOptions(OnnxRuntime.ortApiHandle);
        private boolean closed = false;

        public void setLogLevel(OrtLoggingLevel level) throws OrtException {
            this.checkClosed();
            this.setLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, level.getValue());
        }

        public OrtLoggingLevel getLogLevel() throws OrtException {
            this.checkClosed();
            return OrtLoggingLevel.mapFromInt(this.getLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle));
        }

        public void setLogVerbosityLevel(int level) throws OrtException {
            this.checkClosed();
            this.setLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, level);
        }

        public int getLogVerbosityLevel() throws OrtException {
            this.checkClosed();
            return this.getLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setRunTag(String runTag) throws OrtException {
            this.checkClosed();
            this.setRunTag(OnnxRuntime.ortApiHandle, this.nativeHandle, runTag);
        }

        public String getRunTag() throws OrtException {
            this.checkClosed();
            return this.getRunTag(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setTerminate(boolean terminate) throws OrtException {
            this.checkClosed();
            this.setTerminate(OnnxRuntime.ortApiHandle, this.nativeHandle, terminate);
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed RunOptions");
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IllegalStateException("Trying to close an already closed RunOptions");
            }
            RunOptions.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        private static native long createRunOptions(long var0) throws OrtException;

        private native void setLogLevel(long var1, long var3, int var5) throws OrtException;

        private native int getLogLevel(long var1, long var3) throws OrtException;

        private native void setLogVerbosityLevel(long var1, long var3, int var5) throws OrtException;

        private native int getLogVerbosityLevel(long var1, long var3) throws OrtException;

        private native void setRunTag(long var1, long var3, String var5) throws OrtException;

        private native String getRunTag(long var1, long var3) throws OrtException;

        private native void setTerminate(long var1, long var3, boolean var5) throws OrtException;

        private static native void close(long var0, long var2);
    }

    public static class SessionOptions
    implements AutoCloseable {
        private final long nativeHandle = this.createOptions(OnnxRuntime.ortApiHandle);
        private final List<Long> customLibraryHandles = new ArrayList<Long>();
        private final Map<String, String> configEntries = new LinkedHashMap<String, String>();
        private boolean closed = false;

        @Override
        public void close() {
            if (!this.closed) {
                if (this.customLibraryHandles.size() > 0) {
                    long[] longArray = new long[this.customLibraryHandles.size()];
                    for (int i = 0; i < this.customLibraryHandles.size(); ++i) {
                        longArray[i] = this.customLibraryHandles.get(i);
                    }
                    this.closeCustomLibraries(longArray);
                }
            } else {
                throw new IllegalStateException("Trying to close a closed SessionOptions.");
            }
            this.closeOptions(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed SessionOptions");
            }
        }

        public void setExecutionMode(ExecutionMode mode) throws OrtException {
            this.checkClosed();
            this.setExecutionMode(OnnxRuntime.ortApiHandle, this.nativeHandle, mode.getID());
        }

        public void setOptimizationLevel(OptLevel level) throws OrtException {
            this.checkClosed();
            this.setOptimizationLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, level.getID());
        }

        public void setInterOpNumThreads(int numThreads) throws OrtException {
            this.checkClosed();
            this.setInterOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, numThreads);
        }

        public void setIntraOpNumThreads(int numThreads) throws OrtException {
            this.checkClosed();
            this.setIntraOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, numThreads);
        }

        public void setOptimizedModelFilePath(String outputPath) throws OrtException {
            this.checkClosed();
            this.setOptimizationModelFilePath(OnnxRuntime.ortApiHandle, this.nativeHandle, outputPath);
        }

        public void setLoggerId(String loggerId) throws OrtException {
            this.checkClosed();
            this.setLoggerId(OnnxRuntime.ortApiHandle, this.nativeHandle, loggerId);
        }

        public void enableProfiling(String filePath) throws OrtException {
            this.checkClosed();
            this.enableProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle, filePath);
        }

        public void disableProfiling() throws OrtException {
            this.checkClosed();
            this.disableProfiling(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void setMemoryPatternOptimization(boolean memoryPatternOptimization) throws OrtException {
            this.checkClosed();
            this.setMemoryPatternOptimization(OnnxRuntime.ortApiHandle, this.nativeHandle, memoryPatternOptimization);
        }

        public void setCPUArenaAllocator(boolean useArena) throws OrtException {
            this.checkClosed();
            this.setCPUArenaAllocator(OnnxRuntime.ortApiHandle, this.nativeHandle, useArena);
        }

        public void setSessionLogLevel(OrtLoggingLevel logLevel) throws OrtException {
            this.checkClosed();
            this.setSessionLogLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, logLevel.getValue());
        }

        public void setSessionLogVerbosityLevel(int logLevel) throws OrtException {
            this.checkClosed();
            this.setSessionLogVerbosityLevel(OnnxRuntime.ortApiHandle, this.nativeHandle, logLevel);
        }

        public void registerCustomOpLibrary(String path) throws OrtException {
            this.checkClosed();
            long customHandle = this.registerCustomOpLibrary(OnnxRuntime.ortApiHandle, this.nativeHandle, path);
            this.customLibraryHandles.add(customHandle);
        }

        public void setSymbolicDimensionValue(String dimensionName, long dimensionValue) throws OrtException {
            this.checkClosed();
            this.addFreeDimensionOverrideByName(OnnxRuntime.ortApiHandle, this.nativeHandle, dimensionName, dimensionValue);
        }

        public void disablePerSessionThreads() throws OrtException {
            this.checkClosed();
            this.disablePerSessionThreads(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        public void addConfigEntry(String configKey, String configValue) throws OrtException {
            this.checkClosed();
            this.addConfigEntry(OnnxRuntime.ortApiHandle, this.nativeHandle, configKey, configValue);
            this.configEntries.put(configKey, configValue);
        }

        public Map<String, String> getConfigEntries() {
            this.checkClosed();
            return Collections.unmodifiableMap(this.configEntries);
        }

        public void addCUDA() throws OrtException {
            this.addCUDA(0);
        }

        public void addCUDA(int deviceNum) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractCUDA()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find CUDA shared provider");
            }
            this.addCUDA(OnnxRuntime.ortApiHandle, this.nativeHandle, deviceNum);
        }

        public void addROCM() throws OrtException {
            this.addROCM(0);
        }

        public void addROCM(int deviceNum) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractROCM()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find ROCM shared provider");
            }
            this.addROCM(OnnxRuntime.ortApiHandle, this.nativeHandle, deviceNum);
        }

        public void addCPU(boolean useArena) throws OrtException {
            this.checkClosed();
            this.addCPU(OnnxRuntime.ortApiHandle, this.nativeHandle, useArena ? 1 : 0);
        }

        public void addDnnl(boolean useArena) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractDNNL()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find DNNL shared provider");
            }
            this.addDnnl(OnnxRuntime.ortApiHandle, this.nativeHandle, useArena ? 1 : 0);
        }

        public void addOpenVINO(String deviceId) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractOpenVINO()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find OpenVINO shared provider");
            }
            this.addOpenVINO(OnnxRuntime.ortApiHandle, this.nativeHandle, deviceId);
        }

        public void addTensorrt(int deviceNum) throws OrtException {
            this.checkClosed();
            if (!OnnxRuntime.extractTensorRT()) {
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find TensorRT shared provider");
            }
            this.addTensorrt(OnnxRuntime.ortApiHandle, this.nativeHandle, deviceNum);
        }

        public void addNnapi() throws OrtException {
            this.addNnapi(EnumSet.noneOf(NNAPIFlags.class));
        }

        public void addNnapi(EnumSet<NNAPIFlags> flags) throws OrtException {
            this.checkClosed();
            this.addNnapi(OnnxRuntime.ortApiHandle, this.nativeHandle, OrtFlags.aggregateToInt(flags));
        }

        public void addNuphar(boolean allowUnalignedBuffers, String settings) throws OrtException {
            this.checkClosed();
            this.addNuphar(OnnxRuntime.ortApiHandle, this.nativeHandle, allowUnalignedBuffers ? 1 : 0, settings);
        }

        public void addTvm(String settings) throws OrtException {
            this.checkClosed();
            this.addTvm(OnnxRuntime.ortApiHandle, this.nativeHandle, settings);
        }

        public void addDirectML(int deviceId) throws OrtException {
            this.checkClosed();
            this.addDirectML(OnnxRuntime.ortApiHandle, this.nativeHandle, deviceId);
        }

        public void addACL(boolean useArena) throws OrtException {
            this.checkClosed();
            this.addACL(OnnxRuntime.ortApiHandle, this.nativeHandle, useArena ? 1 : 0);
        }

        public void addArmNN(boolean useArena) throws OrtException {
            this.checkClosed();
            this.addArmNN(OnnxRuntime.ortApiHandle, this.nativeHandle, useArena ? 1 : 0);
        }

        public void addCoreML() throws OrtException {
            this.addCoreML(EnumSet.noneOf(CoreMLFlags.class));
        }

        public void addCoreML(EnumSet<CoreMLFlags> flags) throws OrtException {
            this.checkClosed();
            this.addCoreML(OnnxRuntime.ortApiHandle, this.nativeHandle, OrtFlags.aggregateToInt(flags));
        }

        private native void setExecutionMode(long var1, long var3, int var5) throws OrtException;

        private native void setOptimizationLevel(long var1, long var3, int var5) throws OrtException;

        private native void setInterOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setIntraOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setOptimizationModelFilePath(long var1, long var3, String var5) throws OrtException;

        private native long createOptions(long var1);

        private native void setLoggerId(long var1, long var3, String var5) throws OrtException;

        private native void enableProfiling(long var1, long var3, String var5) throws OrtException;

        private native void disableProfiling(long var1, long var3) throws OrtException;

        private native void setMemoryPatternOptimization(long var1, long var3, boolean var5) throws OrtException;

        private native void setCPUArenaAllocator(long var1, long var3, boolean var5) throws OrtException;

        private native void setSessionLogLevel(long var1, long var3, int var5) throws OrtException;

        private native void setSessionLogVerbosityLevel(long var1, long var3, int var5) throws OrtException;

        private native long registerCustomOpLibrary(long var1, long var3, String var5) throws OrtException;

        private native void closeCustomLibraries(long[] var1);

        private native void closeOptions(long var1, long var3);

        private native void addFreeDimensionOverrideByName(long var1, long var3, String var5, long var6) throws OrtException;

        private native void disablePerSessionThreads(long var1, long var3) throws OrtException;

        private native void addConfigEntry(long var1, long var3, String var5, String var6) throws OrtException;

        private native void addCPU(long var1, long var3, int var5) throws OrtException;

        private native void addCUDA(long var1, long var3, int var5) throws OrtException;

        private native void addROCM(long var1, long var3, int var5) throws OrtException;

        private native void addDnnl(long var1, long var3, int var5) throws OrtException;

        private native void addOpenVINO(long var1, long var3, String var5) throws OrtException;

        private native void addTensorrt(long var1, long var3, int var5) throws OrtException;

        private native void addNnapi(long var1, long var3, int var5) throws OrtException;

        private native void addNuphar(long var1, long var3, int var5, String var6) throws OrtException;

        private native void addTvm(long var1, long var3, String var5) throws OrtException;

        private native void addDirectML(long var1, long var3, int var5) throws OrtException;

        private native void addACL(long var1, long var3, int var5) throws OrtException;

        private native void addArmNN(long var1, long var3, int var5) throws OrtException;

        private native void addCoreML(long var1, long var3, int var5) throws OrtException;

        public static enum ExecutionMode {
            SEQUENTIAL(0),
            PARALLEL(1);

            private final int id;

            private ExecutionMode(int id) {
                this.id = id;
            }

            public int getID() {
                return this.id;
            }
        }

        public static enum OptLevel {
            NO_OPT(0),
            BASIC_OPT(1),
            EXTENDED_OPT(2),
            ALL_OPT(99);

            private final int id;

            private OptLevel(int id) {
                this.id = id;
            }

            public int getID() {
                return this.id;
            }
        }
    }
}

