/*
 * Decompiled with CFR 0.152.
 */
package onnx_wrapper;

import ai.onnxruntime.MapInfo;
import ai.onnxruntime.NodeInfo;
import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import ai.onnxruntime.SequenceInfo;
import ai.onnxruntime.TensorInfo;
import ai.onnxruntime.ValueInfo;
import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.AnyLogicCustomProposalPriority;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Engine;
import com.anylogic.engine.LinkToAgentAnimationSettings;
import com.anylogic.engine.LinkToAgentAnimationSettingsImpl;
import com.anylogic.engine.LinkToAgentCollection;
import com.anylogic.engine.LinkToAgentStandardImpl;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.Scale;
import com.anylogic.engine.elements.IElementDescriptor;
import com.anylogic.engine.markup.Level;
import com.anylogic.engine.markup.LevelElement;
import com.anylogic.engine.presentation.ColorConstants;
import com.anylogic.engine.presentation.LinkToAgentAnimator;
import com.anylogic.engine.presentation.ModelElementDescriptorUtils;
import com.anylogic.engine.presentation.ShapeCurve;
import com.anylogic.engine.presentation.ShapeGroup;
import com.anylogic.engine.presentation.ShapeModelElementsGroup;
import com.anylogic.engine.presentation.ShapePolyLine;
import com.anylogic.engine.presentation.ShapeText;
import com.anylogic.engine.presentation.ShapeTopLevelPresentationGroup;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class OnnxHelper
extends Agent {
    public String targetModel;
    @AnyLogicInternalCodegenAPI
    private static String[] _parameterNames_xjal;
    OrtSession session;
    OrtEnvironment env;
    @AnyLogicInternalCodegenAPI
    private static Map<String, IElementDescriptor> elementDesciptors_xjal;
    @AnyLogicCustomProposalPriority(type=AnyLogicCustomProposalPriority.Type.STATIC_ELEMENT)
    public static final Scale scale;
    @AnyLogicInternalCodegenAPI
    protected static final int _STATECHART_COUNT_xjal = 0;
    @AnyLogicInternalCodegenAPI
    protected static final Font _text1_Font;
    @AnyLogicInternalCodegenAPI
    protected static final Font _text_Font;
    @AnyLogicInternalCodegenAPI
    protected static final Font _text2_Font;
    protected static final Color _outline_Fill_Color;
    protected static final Color _outline_Line_Color;
    protected static final Color _topShadow_Fill_Color;
    protected static final Color _topShadow_Line_Color;
    protected static final Color _topHighlight_Fill_Color;
    protected static final Color _topHighlight_Line_Color;
    protected static final Color _bottomShadow_Fill_Color;
    protected static final Color _bottomShadow_Line_Color;
    protected static final Color _bottomHighlight_Fill_Color;
    protected static final Color _bottomHighlight_Line_Color;
    @AnyLogicInternalCodegenAPI
    protected static final int _text1 = 1;
    @AnyLogicInternalCodegenAPI
    protected static final int _outline = 2;
    @AnyLogicInternalCodegenAPI
    protected static final int _topShadow = 3;
    @AnyLogicInternalCodegenAPI
    protected static final int _topHighlight = 4;
    @AnyLogicInternalCodegenAPI
    protected static final int _bottomShadow = 5;
    @AnyLogicInternalCodegenAPI
    protected static final int _bottomHighlight = 6;
    @AnyLogicInternalCodegenAPI
    protected static final int _group = 7;
    @AnyLogicInternalCodegenAPI
    protected static final int _text = 8;
    @AnyLogicInternalCodegenAPI
    protected static final int _text2 = 9;
    @AnyLogicInternalCodegenAPI
    protected static final int _SHAPE_NEXT_ID_xjal = 10;
    protected ShapeText text1;
    protected ShapeCurve outline;
    protected ShapeCurve topShadow;
    protected ShapePolyLine topHighlight;
    protected ShapeCurve bottomShadow;
    protected ShapePolyLine bottomHighlight;
    protected ShapeGroup group;
    protected ShapeText text;
    protected ShapeText text2;
    protected Level level;
    private Level[] _getLevels_xjal;
    protected ShapeTopLevelPresentationGroup presentation;
    protected ShapeModelElementsGroup icon;
    @AnyLogicInternalCodegenAPI
    public static LinkToAgentAnimationSettings _connections_commonAnimationSettings_xjal;
    public LinkToAgentCollection<Agent, Agent> connections = new LinkToAgentStandardImpl((Agent)this, _connections_commonAnimationSettings_xjal);
    private static final ObjectMapper mapper;
    @AnyLogicInternalCodegenAPI
    private static final long serialVersionUID = 615490492907102570L;

    static {
        elementDesciptors_xjal = OnnxHelper.createElementDescriptors(OnnxHelper.class);
        scale = new Scale(10.0);
        _text_Font = _text1_Font = new Font("SansSerif", 0, 10);
        _text2_Font = _text1_Font;
        _outline_Fill_Color = new Color(-15461356, true);
        _outline_Line_Color = new Color(-12698050, true);
        _topShadow_Fill_Color = new Color(-16316665, true);
        _topShadow_Line_Color = new Color(-16316665, true);
        _topHighlight_Fill_Color = new Color(-12698050, true);
        _topHighlight_Line_Color = new Color(-12698050, true);
        _bottomShadow_Fill_Color = new Color(-16316665, true);
        _bottomShadow_Line_Color = new Color(-16316665, true);
        _bottomHighlight_Fill_Color = new Color(-14803426, true);
        _bottomHighlight_Line_Color = new Color(-14803426, true);
        _connections_commonAnimationSettings_xjal = new LinkToAgentAnimationSettingsImpl(false, ColorConstants.black, 1.0, LINE_STYLE_SOLID, ARROW_NONE, 0.0);
        mapper = new ObjectMapper();
    }

    @AnyLogicInternalCodegenAPI
    public String _targetModel_DefaultValue_xjal() {
        OnnxHelper self = this;
        return null;
    }

    public void set_targetModel(String value) {
        if (value == this.targetModel) {
            return;
        }
        String _oldValue_xjal = this.targetModel;
        this.targetModel = value;
        this.onChange_targetModel_xjal(_oldValue_xjal);
        this.onChange();
    }

    protected void onChange_targetModel() {
        this.onChange_targetModel_xjal(this.targetModel);
    }

    @AnyLogicInternalCodegenAPI
    protected void onChange_targetModel_xjal(String oldValue) {
        this.reloadSession();
    }

    public void setParametersToDefaultValues() {
        super.setParametersToDefaultValues();
        this.targetModel = this._targetModel_DefaultValue_xjal();
    }

    public boolean setParameter(String _name_xjal, Object _value_xjal, boolean _callOnChange_xjal) {
        switch (_name_xjal) {
            case "targetModel": {
                if (_callOnChange_xjal) {
                    this.set_targetModel((String)_value_xjal);
                } else {
                    this.targetModel = (String)_value_xjal;
                }
                return true;
            }
        }
        return super.setParameter(_name_xjal, _value_xjal, _callOnChange_xjal);
    }

    public <T> T getParameter(String _name_xjal) {
        Object _result_xjal;
        switch (_name_xjal) {
            case "targetModel": {
                _result_xjal = this.targetModel;
                break;
            }
            default: {
                _result_xjal = super.getParameter(_name_xjal);
            }
        }
        return (T)_result_xjal;
    }

    public String[] getParameterNames() {
        String[] result = _parameterNames_xjal;
        if (result == null) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getParameterNames()));
            list.add("targetModel");
            result = list.toArray(new String[list.size()]);
            _parameterNames_xjal = result;
        }
        return result;
    }

    @AnyLogicInternalCodegenAPI
    public Map<String, IElementDescriptor> getElementDesciptors() {
        return elementDesciptors_xjal;
    }

    public Scale getScale() {
        return scale;
    }

    public void reloadSession() {
        try {
            this.session = this.env.createSession(this.targetModel, new OrtSession.SessionOptions());
        }
        catch (OrtException e) {
            this.error(e, "Failed to import ONNX model");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Active session target: " + this.targetModel.replaceFirst(".+[\\/\\\\](?=.+?\\.onnx)", ""));
        try {
            sb.append("\n[Inputs]\n\t");
            sb.append(this.session.getInputInfo().values().stream().map(i -> this.nodeInfoToString((NodeInfo)i)).collect(Collectors.joining("\n\t")));
            sb.append("\n[Outputs]\n\t");
            sb.append(this.session.getOutputInfo().values().stream().map(i -> this.nodeInfoToString((NodeInfo)i)).collect(Collectors.joining("\n\t")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    String nodeInfoToString(NodeInfo nodeInfo) {
        StringBuilder sb = new StringBuilder(nodeInfo.getName());
        ValueInfo valueInfo = nodeInfo.getInfo();
        if (valueInfo.getClass().isAssignableFrom(TensorInfo.class)) {
            TensorInfo info = (TensorInfo)valueInfo;
            sb.append(String.format(": %s[%s]", this.onnxTypeToJavaName(info.type), this.encodeShape(info.getShape())));
        } else if (valueInfo.getClass().isAssignableFrom(MapInfo.class)) {
            MapInfo info = (MapInfo)valueInfo;
            sb.append(String.format(": %s -> %s | x%s", this.onnxTypeToJavaName(info.keyType), this.onnxTypeToJavaName(info.valueType), info.size));
        } else if (valueInfo.getClass().isAssignableFrom(SequenceInfo.class)) {
            SequenceInfo info = (SequenceInfo)valueInfo;
            sb.append(info.mapInfo.toString());
        }
        return sb.toString();
    }

    public <T> T predict(Class<T> returnType, Map<String, Object> input) {
        Map<String, Object> output = this.predict(input);
        return this.outputMapToType(returnType, output);
    }

    String encodeShape(long[] shape) {
        return Arrays.toString(shape).replaceAll("[\\[\\] ]", "").replaceAll("-1", "*");
    }

    <T> T outputMapToType(Class<T> returnType, Map<String, Object> outputMap) {
        if (Map.class.isAssignableFrom(returnType)) {
            return returnType.cast(outputMap);
        }
        if (List.class.isAssignableFrom(returnType)) {
            List outputList = outputMap.entrySet().stream().map(e -> e.getValue()).collect(Collectors.toList());
            return returnType.cast(outputList);
        }
        if (Set.class.isAssignableFrom(returnType)) {
            Set outputList = outputMap.entrySet().stream().map(e -> e.getValue()).collect(Collectors.toSet());
            return returnType.cast(outputList);
        }
        if (returnType.isPrimitive()) {
            return returnType.cast(outputMap.values().stream().findFirst().get());
        }
        if (returnType.isArray()) {
            if (outputMap.size() == 1) {
                return returnType.cast(outputMap.values().stream().findFirst().get());
            }
            Object retVals = Array.newInstance(returnType.getComponentType(), outputMap.size());
            ArrayList<Object> mapVals = new ArrayList<Object>(outputMap.values());
            IntStream.range(0, mapVals.size()).forEachOrdered(i -> Array.set(retVals, i, mapVals.get(i)));
            return (T)retVals;
        }
        this.error("Return type not currently supported: %s", new Object[]{returnType});
        return null;
    }

    String encodeShape(int[] shape) {
        return Arrays.toString(shape).replaceAll("[\\[\\] ]", "");
    }

    public static int[] argMax(float[][] array) {
        int[] maxes = new int[array.length];
        int i = 0;
        while (i < array.length) {
            maxes[i] = OnnxHelper.argMax(array[i]);
            ++i;
        }
        return maxes;
    }

    public static int argMax(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        int idx = 0;
        float val = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > val) {
                idx = i;
                val = array[i];
            }
            ++i;
        }
        return idx;
    }

    public static int[] argMax(double[][] array) {
        int[] maxes = new int[array.length];
        int i = 0;
        while (i < array.length) {
            maxes[i] = OnnxHelper.argMax(array[i]);
            ++i;
        }
        return maxes;
    }

    public static int argMax(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        int idx = 0;
        double val = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] > val) {
                idx = i;
                val = array[i];
            }
            ++i;
        }
        return idx;
    }

    public static <T> T convert(Object object, Class<T> outputType) {
        try {
            return (T)mapper.convertValue(object, outputType);
        }
        catch (Exception e) {
            OnnxHelper.traceln((String)"Conversion of object (type %s) to type %s failed, returning null. Reason: %s", (Object[])new Object[]{object.getClass(), outputType, e});
            e.printStackTrace();
            return null;
        }
    }

    Map<String, Object> inputDataToMap(Object ... inputs) {
        HashMap<String, Object> imap = new HashMap<String, Object>();
        if (Number.class.isAssignableFrom(inputs[0].getClass())) {
            inputs = new Object[]{ArrayUtils.toPrimitive(inputs)};
        }
        try {
            int i = 0;
            for (Map.Entry<String, NodeInfo> entries : this.session.getInputInfo().entrySet()) {
                String name = entries.getKey();
                Object obj = inputs[i];
                ValueInfo vinfo = entries.getValue().getInfo();
                if (!vinfo.getClass().isAssignableFrom(TensorInfo.class)) {
                    this.error("Not implemented: handling of node type %s.", new Object[]{vinfo.getClass()});
                }
                TensorInfo info = (TensorInfo)vinfo;
                String expectedShape = this.encodeShape(info.getShape());
                String actualShape = this.encodeShape(this.findArrayDims(obj));
                if (!actualShape.matches(expectedShape.replace("*", "\\d+"))) {
                    this.error("Object at index %s (shape %s) failed to match expected size (input '%s', shape %s). See the inspection window of the wrapper object for order/type information.", new Object[]{i, actualShape, name, expectedShape});
                }
                Class<?> rootType = this.getRootComponentType(obj);
                OnnxJavaType cfr_ignored_0 = info.type;
                OnnxJavaType convertedType = OnnxJavaType.mapFromClass(rootType);
                if (!info.type.equals((Object)convertedType)) {
                    this.error("Object at index %s (shape %s, component type %s / onnx type %s) failed to match expected type (input '%s', onnx type %s). See the inspection window of the wrapper object for order/type information.", new Object[]{i, actualShape, rootType, convertedType, name, info.type});
                }
                imap.put(name, obj);
                ++i;
            }
        }
        catch (Exception e) {
            this.error(e, "Problem with getting info in session");
        }
        return imap;
    }

    public <T> T predict(Class<T> returnType, Object ... inputs) {
        Map<String, Object> input = this.inputDataToMap(inputs);
        return this.predict(returnType, input);
    }

    public Map<String, Object> predict(Map<String, Object> input) {
        if (this.session == null) {
            this.error("No ONNX models are loaded. Fill in the target model parameter or call `set_targetModel`");
        }
        try {
            HashMap<String, OnnxTensor> tensorInputs = new HashMap<String, OnnxTensor>();
            for (String name : input.keySet()) {
                OnnxTensor tensor = OnnxTensor.createTensor(this.env, input.get(name));
                tensorInputs.put(name, tensor);
            }
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            OrtSession.Result result = this.session.run(tensorInputs);
            for (Map.Entry<String, OnnxValue> entry : result) {
                outputs.put(entry.getKey(), entry.getValue().getValue());
            }
            return outputs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T[] flatten(Object object, Class<T> elementType) {
        Stream<Object> stream = OnnxHelper._flatten(object);
        Object[] objArray = stream.toArray();
        Object[] genArray = elementType.equals(Integer.TYPE) || elementType.equals(Integer.class) ? new Integer[objArray.length] : (elementType.equals(Long.TYPE) || elementType.equals(Long.class) ? new Long[objArray.length] : (elementType.equals(Float.TYPE) || elementType.equals(Float.class) ? new Float[objArray.length] : (elementType.equals(Double.TYPE) || elementType.equals(Double.class) ? new Double[objArray.length] : new Object[objArray.length])));
        IntStream.range(0, objArray.length).forEach(i -> {
            Object object = objArray[i];
        });
        return genArray;
    }

    private static Stream<Object> _flatten(Object object) {
        Stream<Object> stream = object != null && object.getClass().isArray() ? IntStream.range(0, Array.getLength(object)).mapToObj(ix -> Array.get(object, ix)).flatMap(x -> OnnxHelper._flatten(x)) : Stream.of(object);
        return stream;
    }

    public static int[] argMin(float[][] array) {
        int[] mins = new int[array.length];
        int i = 0;
        while (i < array.length) {
            mins[i] = OnnxHelper.argMin(array[i]);
            ++i;
        }
        return mins;
    }

    public static int argMin(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        int idx = 0;
        float val = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < val) {
                idx = i;
                val = array[i];
            }
            ++i;
        }
        return idx;
    }

    public static int[] argMin(double[][] array) {
        int[] mins = new int[array.length];
        int i = 0;
        while (i < array.length) {
            mins[i] = OnnxHelper.argMin(array[i]);
            ++i;
        }
        return mins;
    }

    public static int argMin(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        int idx = 0;
        double val = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] < val) {
                idx = i;
                val = array[i];
            }
            ++i;
        }
        return idx;
    }

    public <T> Map<String, Object> predict(Object ... inputs) {
        Map<String, Object> input = this.inputDataToMap(inputs);
        return this.predict(input);
    }

    String onnxTypeToJavaName(OnnxJavaType onnxType) {
        switch (onnxType) {
            case BOOL: {
                return "boolean";
            }
            case INT8: {
                return "byte";
            }
            case INT16: {
                return "short";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                return "String";
            }
        }
        return "Unknown";
    }

    String onnxTypeToJavaName(TensorInfo.OnnxTensorType tensorType) {
        return this.onnxTypeToJavaName(OnnxJavaType.mapFromOnnxTensorType(tensorType));
    }

    @AnyLogicInternalCodegenAPI
    public boolean isPublicPresentationDefined() {
        return false;
    }

    @AnyLogicInternalCodegenAPI
    public boolean isEmbeddedAgentPresentationVisible(Agent _a) {
        return super.isEmbeddedAgentPresentationVisible(_a);
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _outline_pointsDX_xjal() {
        return new double[]{0.0, -1.0, -12.0, -12.0, -12.0, -10.0, 0.0, 10.0, 13.0, 13.0, 13.0, 1.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _outline_pointsDY_xjal() {
        return new double[]{0.0, 0.0, 11.0, 21.0, 28.0, 35.0, 35.0, 35.0, 28.0, 21.0, 11.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _outline_pointsDZ_xjal() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topShadow_pointsDX_xjal() {
        return new double[]{0.0, -1.0, -12.0, -12.0, -12.0, -11.15, -11.15, -11.15, -9.0, -9.0, -9.0, 0.0, 0.0, 0.0, 10.0, 10.0, 10.0, 11.633, 11.633, 11.633, 13.0, 13.0, 13.0, 1.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topShadow_pointsDY_xjal() {
        return new double[]{0.0, 0.0, 11.0, 21.0, 21.0, 18.6, 18.6, 18.6, 20.0, 20.0, 20.0, 11.0, 11.0, 11.0, 20.0, 20.0, 20.0, 17.4, 17.4, 17.4, 21.0, 21.0, 11.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topShadow_pointsDZ_xjal() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topHighlight_pointsDX_xjal() {
        return new double[]{0.0, 5.0, 5.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topHighlight_pointsDY_xjal() {
        return new double[]{0.0, 8.0, 14.475, 10.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _topHighlight_pointsDZ_xjal() {
        return new double[]{0.0, 0.0, 0.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomShadow_pointsDX_xjal() {
        return new double[]{0.0, 0.0, -7.0, -7.0, -7.0, -12.0, -12.0, -12.0, -10.966999999999999, -10.966999999999999, -10.966999999999999, -8.0, -5.0, 5.0, 8.0, 8.0, 8.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomShadow_pointsDY_xjal() {
        return new double[]{0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 1.867, 1.867, 1.867, 3.0, 3.0, 3.0, -4.0, -11.0, -11.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomShadow_pointsDZ_xjal() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomHighlight_pointsDX_xjal() {
        return new double[]{0.0, -2.7000000000000006, -3.5, -1.5249999999999997, -0.6499999999999999};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomHighlight_pointsDY_xjal() {
        return new double[]{0.0, 2.0500000000000003, 4.45, 3.6, 1.975};
    }

    @AnyLogicInternalCodegenAPI
    protected static final double[] _bottomHighlight_pointsDZ_xjal() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @AnyLogicInternalCodegenAPI
    private void _initialize_level_xjal() {
        this.level.addAll(new LevelElement[]{this.text1, this.text, this.text2});
    }

    @AnyLogicInternalCodegenAPI
    public boolean onShapeClick(int _shape, int index, double clickx, double clicky) {
        switch (_shape) {
            case 7: {
                ShapeGroup self = this.group;
                return true;
            }
        }
        return super.onShapeClick(_shape, index, clickx, clicky);
    }

    public Level[] getLevels() {
        return this._getLevels_xjal;
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsBP0_xjal() {
        this.text1 = new ShapeText(SHAPE_DRAW_2D, false, 250.0, 370.0, 0.0, 0.0, ColorConstants.red, "Helper functions", _text1_Font, ALIGNMENT_LEFT);
        this.outline = new ShapeCurve(true, 0.0, -16.0, (Paint)_outline_Line_Color, (Paint)_outline_Fill_Color, 12, true, OnnxHelper._outline_pointsDX_xjal(), OnnxHelper._outline_pointsDY_xjal(), true, 0.5, LINE_STYLE_SOLID);
        this.topShadow = new ShapeCurve(true, 0.0, -16.0, (Paint)_topShadow_Line_Color, (Paint)_topShadow_Fill_Color, 24, true, OnnxHelper._topShadow_pointsDX_xjal(), OnnxHelper._topShadow_pointsDY_xjal(), true, 0.1, LINE_STYLE_SOLID);
        this.topHighlight = new ShapePolyLine(SHAPE_DRAW_2D, true, 0.0, -15.0, 0.0, (Paint)_topHighlight_Line_Color, (Paint)_topHighlight_Fill_Color, 4, OnnxHelper._topHighlight_pointsDX_xjal(), OnnxHelper._topHighlight_pointsDY_xjal(), OnnxHelper._topHighlight_pointsDZ_xjal(), true, 10.0, 0.1, LINE_STYLE_SOLID);
        this.bottomShadow = new ShapeCurve(true, 5.0, 16.0, (Paint)_bottomShadow_Line_Color, (Paint)_bottomShadow_Fill_Color, 18, true, OnnxHelper._bottomShadow_pointsDX_xjal(), OnnxHelper._bottomShadow_pointsDY_xjal(), true, 0.1, LINE_STYLE_SOLID);
        this.bottomHighlight = new ShapePolyLine(SHAPE_DRAW_2D, true, 12.35, 10.275, 0.0, (Paint)_bottomHighlight_Line_Color, (Paint)_bottomHighlight_Fill_Color, 5, OnnxHelper._bottomHighlight_pointsDX_xjal(), OnnxHelper._bottomHighlight_pointsDY_xjal(), OnnxHelper._bottomHighlight_pointsDZ_xjal(), true, 10.0, 0.1, LINE_STYLE_SOLID);
        this.text = new ShapeText(SHAPE_DRAW_2D, false, 250.0, 90.0, 0.0, 0.0, ColorConstants.black, "Base method (map input -> map output)", _text_Font, ALIGNMENT_LEFT);
        this.text2 = new ShapeText(SHAPE_DRAW_2D, false, 250.0, 140.0, 0.0, 0.0, ColorConstants.black, "Derivative methods (map or list input -> custom typed output)", _text2_Font, ALIGNMENT_LEFT);
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsAP0_xjal() {
        this.group = new ShapeGroup((Presentable)this, SHAPE_DRAW_2D, true, 0.0, 0.0, 0.0, 0.0, new Object[]{this.outline, this.topShadow, this.topHighlight, this.bottomShadow, this.bottomHighlight}){
            @AnyLogicInternalCodegenAPI
            private static final long serialVersionUID = 615490492906337327L;

            @AnyLogicInternalCodegenAPI
            public boolean onClick(double clickx, double clicky) {
                return OnnxHelper.this.onShapeClick(7, 0, clickx, clicky);
            }
        };
    }

    @AnyLogicInternalCodegenAPI
    private void _createPersistentElementsBS0_xjal() {
    }

    private void instantiatePersistentElements_xjal() {
        this.level = new Level((Agent)this, "level", SHAPE_DRAW_2D3D, 0.0, true, true);
        this._getLevels_xjal = new Level[]{this.level};
        this._createPersistentElementsBP0_xjal();
    }

    @AnyLogicInternalCodegenAPI
    public ShapeTopLevelPresentationGroup getPresentationShape() {
        return this.presentation;
    }

    @AnyLogicInternalCodegenAPI
    public ShapeModelElementsGroup getModelElementsShape() {
        return this.icon;
    }

    public OnnxHelper(Engine engine, Agent owner, AgentList<? extends OnnxHelper> ownerPopulation) {
        super(engine, owner, ownerPopulation);
        this.instantiateBaseStructureThis_xjal();
    }

    @AnyLogicInternalCodegenAPI
    public void onOwnerChanged_xjal() {
        super.onOwnerChanged_xjal();
        this.setupReferences_xjal();
    }

    @AnyLogicInternalCodegenAPI
    public void instantiateBaseStructure_xjal() {
        super.instantiateBaseStructure_xjal();
        this.instantiateBaseStructureThis_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void instantiateBaseStructureThis_xjal() {
        this.instantiatePersistentElements_xjal();
        this.setupReferences_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void setupReferences_xjal() {
    }

    public OnnxHelper() {
    }

    public OnnxHelper(String targetModel) {
        this.markParametersAreSet();
        this.targetModel = targetModel;
    }

    @AnyLogicInternalCodegenAPI
    public void doCreate() {
        super.doCreate();
        this.setupPlainVariables_OnnxHelper_xjal();
        this._createPersistentElementsAP0_xjal();
        this._initialize_level_xjal();
        this.level.initialize();
        this.presentation = new ShapeTopLevelPresentationGroup((Presentable)this, true, 0.0, 0.0, 0.0, 0.0, new Object[]{this.level});
        this.icon = new ShapeModelElementsGroup((Presentable)this, (ModelElementDescriptorUtils[])this.getElementProperty("onnx_wrapper.OnnxHelper.icon", "modelElementDescriptors"), new Object[]{this.group});
        this.icon.setIconOffsets(0.0, -10.0);
        this.setupInitialConditions_xjal(OnnxHelper.class);
        this._createPersistentElementsBS0_xjal();
    }

    @AnyLogicInternalCodegenAPI
    public void doStart() {
        super.doStart();
    }

    @AnyLogicInternalCodegenAPI
    public void onStartup() {
        super.onStartup();
        if (this.targetModel != null) {
            this.reloadSession();
        }
    }

    @AnyLogicInternalCodegenAPI
    public void setupPlainVariables_xjal() {
        this.setupPlainVariables_OnnxHelper_xjal();
    }

    @AnyLogicInternalCodegenAPI
    private void setupPlainVariables_OnnxHelper_xjal() {
        this.env = OrtEnvironment.getEnvironment();
    }

    public LinkToAgentCollection<? extends Agent, ? extends Agent> getLinkToAgentStandard_xjal() {
        return this.connections;
    }

    @AnyLogicInternalCodegenAPI
    public void drawLinksToAgents(boolean _underAgents_xjal, LinkToAgentAnimator _animator_xjal) {
        super.drawLinksToAgents(_underAgents_xjal, _animator_xjal);
        if (_underAgents_xjal) {
            _animator_xjal.drawLink((Agent)this, this.connections, true, true);
        }
    }

    public AgentList<? extends OnnxHelper> getPopulation() {
        return super.getPopulation();
    }

    public List<? extends OnnxHelper> agentsInRange(double distance) {
        return super.agentsInRange(distance);
    }

    int[] findArrayDims(Object o) {
        return this._findArrayDims(o, new ArrayList<Integer>()).stream().mapToInt(i -> i).toArray();
    }

    private ArrayList<Integer> _findArrayDims(Object o, ArrayList<Integer> dims) {
        if (o.getClass().isArray()) {
            if (Array.get(o, 0).getClass().isArray()) {
                dims.add(Array.getLength(o));
                return this._findArrayDims(Array.get(o, 0), dims);
            }
            dims.add(Array.getLength(o));
            return dims;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            Collection c = (Collection)o;
            dims.add(c.size());
            return dims;
        }
        return null;
    }

    Class<?> getRootComponentType(Object o) {
        return this._getRootComponentType(o.getClass());
    }

    private Class<?> _getRootComponentType(Class<?> cls) {
        if (cls.isArray()) {
            return this._getRootComponentType(cls.getComponentType());
        }
        return cls;
    }
}

