.386
.model flat, stdcall  ;32 bit memory model
option casemap :none  ;case sensitive

include Alexandr.inc

.code

start:

	invoke GetModuleHandle,NULL
	mov		hInstance,eax
	invoke InitCommonControls
	invoke WizShow
	invoke ExitProcess,0

;########################################################################

WizShow proc
	LOCAL	PropSheet[3]:PROPSHEETPAGE
	LOCAL	PropHdr:PROPSHEETHEADER

	;Set up the 1st property sheet
	mov		PropSheet.dwSize,sizeof PROPSHEETPAGE
	m2m		PropSheet.dwFlags,PSP_DEFAULT
	m2m		PropSheet.hInstance,hInstance
	m2m		PropSheet.pszTemplate,IDD_WIZ1
	mov		PropSheet.pszIcon,0
	m2m		PropSheet.pfnDlgProc,offset WizDialog1
	m2m		PropSheet.pszTitle,NULL
	mov		PropSheet.lParam,0
	mov		PropSheet.pfnCallback,0
	;Set up the 2nd property sheet
	mov		PropSheet[(sizeof PROPSHEETPAGE)].dwSize,sizeof PROPSHEETPAGE
	m2m		PropSheet[(sizeof PROPSHEETPAGE)].dwFlags,PSP_DEFAULT
	m2m		PropSheet[(sizeof PROPSHEETPAGE)].hInstance,hInstance
	m2m		PropSheet[(sizeof PROPSHEETPAGE)].pszTemplate,IDD_WIZ2
	mov		PropSheet[(sizeof PROPSHEETPAGE)].pszIcon,0
	m2m		PropSheet[(sizeof PROPSHEETPAGE)].pfnDlgProc,offset WizDialog2
	m2m		PropSheet[(sizeof PROPSHEETPAGE)].pszTitle,NULL
	mov		PropSheet[(sizeof PROPSHEETPAGE)].lParam,0
	mov		PropSheet[(sizeof PROPSHEETPAGE)].pfnCallback,0
	;Set up the 3rd property sheet
	mov		PropSheet[(sizeof PROPSHEETPAGE)*2].dwSize,sizeof PROPSHEETPAGE
	m2m		PropSheet[(sizeof PROPSHEETPAGE)*2].dwFlags,PSP_DEFAULT
	m2m		PropSheet[(sizeof PROPSHEETPAGE)*2].hInstance,hInstance
	m2m		PropSheet[(sizeof PROPSHEETPAGE)*2].pszTemplate,IDD_WIZ3
	mov		PropSheet[(sizeof PROPSHEETPAGE)*2].pszIcon,0
	m2m		PropSheet[(sizeof PROPSHEETPAGE)*2].pfnDlgProc,offset WizDialog3
	m2m		PropSheet[(sizeof PROPSHEETPAGE)*2].pszTitle,NULL
	mov		PropSheet[(sizeof PROPSHEETPAGE)*2].lParam,0
	mov		PropSheet[(sizeof PROPSHEETPAGE)*2].pfnCallback,0
	; Create the 3 Pages
	invoke CreatePropertySheetPage,addr PropSheet
	mov		hPs[0],eax
	invoke CreatePropertySheetPage,addr PropSheet[sizeof PROPSHEETPAGE]
	mov		hPs[4],eax
	invoke CreatePropertySheetPage,addr PropSheet[(sizeof PROPSHEETPAGE)*2]
	mov		hPs[8],eax
	; Set up the property sheet header
	mov		PropHdr.dwSize,sizeof PROPSHEETHEADER
	mov		PropHdr.dwFlags,PSH_Alexandr
	m2m		PropHdr.hwndParent,NULL
	m2m		PropHdr.hInstance,hInstance
	mov		PropHdr.pszIcon,0
	m2m		PropHdr.pszCaption,NULL
	mov		PropHdr.nPages,3
	mov		PropHdr.nStartPage,0
	m2m		PropHdr.phpage,offset hPs
	mov		PropHdr.pfnCallback,0
	; Display the property sheet control
	invoke PropertySheet,addr PropHdr
	ret

WizShow endp

WizDialog1 proc hWin:HWND,uMsg:DWORD,wParam:WPARAM,lParam:LPARAM
	;This dialog processes property page 1

	mov		eax,uMsg
	.if	eax==WM_NOTIFY
		mov	edx,lParam
		mov	eax,NMHDR.code[edx]
		.if eax==PSN_SETACTIVE
			;page gaining focus
			m2m		hPropSheet,NMHDR.hwndFrom[edx]
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
			invoke PostMessage,hPropSheet,PSM_SETWIZBUTTONS,0,PSN_WIZBACK
		.elseif eax==PSN_KILLACTIVE
			;page loosing focus
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
		.elseif eax==PSN_RESET
			;Add own cancel code here
		.endif
	.elseif eax==WM_COMMAND
		mov 	eax,wParam
		and		eax,0FFFFh
	.elseif eax==WM_INITDIALOG
		m2m		hPsDlg[0],hWin
	.else
		return FALSE
	.endif
	return TRUE

WizDialog1 endp

WizDialog2 proc hWin:HWND,uMsg:DWORD,wParam:WPARAM,lParam:LPARAM
	; This dialog processes property page 2

	mov	eax,uMsg
	.if	eax==WM_NOTIFY
		mov		edx,lParam
		mov		eax,NMHDR.code[edx]
		.if eax==PSN_SETACTIVE
			;page gaining focus
			m2m		hPropSheet,NMHDR.hwndFrom[edx]
			invoke PostMessage,hPropSheet,PSM_SETWIZBUTTONS,0,PSWIZB_NEXT or PSWIZB_BACK
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
		.elseif eax==PSN_KILLACTIVE
			;page loosing focus
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
		.elseif eax==PSN_RESET
			;Add own cancel code here
		.endif
	.elseif eax==WM_COMMAND
		mov 	eax,wParam
		and		eax,0FFFFh
	.elseif eax==WM_INITDIALOG
		m2m		hPsDlg[4],hWin
	.else
		return FALSE
	.endif
	return TRUE

WizDialog2	endp

WizDialog3	proc hWin:DWORD,uMsg:DWORD,wParam:WPARAM,lParam:LPARAM
	; This dialog processes property page 3

	mov	eax,uMsg
	.if	eax==WM_NOTIFY
		mov		edx,lParam
		mov		eax,NMHDR.code[edx]
		.if eax==PSN_SETACTIVE		; page gaining focus
			m2m		hPropSheet,NMHDR.hwndFrom[edx]
			invoke PostMessage,hPropSheet,PSM_SETWIZBUTTONS,0,PSWIZB_FINISH or PSWIZB_BACK
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
		.elseif eax==PSN_KILLACTIVE
			;page loosing focus
			invoke SetWindowLong,hWin,DWL_MSGRESULT,0
		.elseif eax==PSN_WIZFINISH
		.elseif eax==PSN_RESET
			;Add own cancel code here
		.endif
	.elseif eax==WM_COMMAND
		mov 	eax,wParam
		and		eax,0FFFFh
	.elseif eax==WM_INITDIALOG
		m2m		hPsDlg[8],hWin
	.else
		return FALSE
	.endif
	return TRUE

WizDialog3	endp

end start
