;-------------------------------------------------------------------------------
;
; bstrLeft procedure 
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke bstrLeft, bstrSource, dwCCount, ADDR bstrReturn
;
; Description: extracts the first dwCCount characters from bstrSource, 
;   and returns it in *bstrName
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\include\user32.inc

CoTaskMemAlloc	PROTO :DWORD
lstrcpyW		PROTO :DWORD, :DWORD
lstrcatW		PROTO :DWORD, :DWORD
;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
bstrCat PROC pbstrDest:DWORD, bstrAddition:DWORD
	LOCAL pwszNew:DWORD, len:DWORD
	
	; get string length total
	invoke SysStringLen, bstrAddition
	mov len, eax
	mov ecx, pbstrDest
	mov ecx, [ecx]
	invoke SysStringLen, ecx
	add len, eax
	inc len		; trailing zero
	rol len, 1	; make it W I D E, then alloc for it
	invoke CoTaskMemAlloc, len
	; copy the dest string to the buffer
	mov pwszNew, eax
	mov ecx, pbstrDest
	mov ecx, [ecx]
	invoke lstrcpyW, pwszNew, ecx
	; cat the source string in
	invoke lstrcatW, pwszNew, bstrAddition	
	; realloc this cat string, and return
	invoke SysReAllocString, pbstrDest, pwszNew
	ret
bstrCat ENDP;-------------------------------------------------------------------------------

END