;-------------------------------------------------------------------------------
;
; GetPrivateProfileBSTRING    PROTO :DWORD, :DWORD, :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
;   useage prototype
;    invoke GetPrivateProfileBSTRING, bstrSection, bstrKeyName, 
;                                     ADDR bstrData, bstrFileName
;   follows same convention of GetPrivateProfileString, but uses BSTR,
;    assigns it's own buffers, and defaults to a NULL bstr for a not found entry
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------
include \masm32\include\ole32.inc
;include \masm32\include\shell32.inc
include \masm32\include\oleaut32.inc
include \masm32\include\kernel32.inc

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc

;-------------------------------------------------------------------------------
.LISTALL
.code

;-------------------------------------------------------------------------------
GetPrivateProfileBSTRING    PROC PUBLIC bstrSection, bstrKeyName, pbstrData, bstrFileName
    LOCAL pszSection:DWORD, pszKeyName:DWORD, pszFileName:DWORD
    LOCAL cszSection:DWORD, cszKeyName:DWORD, cszFileName:DWORD
    LOCAL szData[257]:BYTE, wszData[257]:wchar
    LOCAL cCount:DWORD,     szNULL:DWORD
    
    mov szNULL, 0
    invoke SysStringLen, bstrSection
    add eax, 2      ; allow for trailing zero
    mov cszSection, eax
    mov cCount, eax
    mov pszKeyName, eax     ; pointer offset
    invoke SysStringLen, bstrKeyName
    add eax, 2      ; allow for trailing zero
    mov cszKeyName, eax
    add cCount, eax
    mov eax, cCount
    mov pszFileName, eax    ; pointer offset
    invoke SysStringLen, bstrFileName
    add eax, 2      ; allow for trailing zero
    mov cszFileName, eax
    add cCount, eax
	invoke CoTaskMemAlloc, cCount
    ; now make our pointers
    mov pszSection, eax     ; has offset of zero
    add pszKeyName, eax
    add pszFileName, eax
    ; convert wide strings to ascii
    invoke WideCharToMultiByte, CP_ACP, 0, bstrSection,  -1, pszSection,  cszSection,  NULL, NULL
    invoke WideCharToMultiByte, CP_ACP, 0, bstrKeyName,  -1, pszKeyName,  cszKeyName,  NULL, NULL
    invoke WideCharToMultiByte, CP_ACP, 0, bstrFileName, -1, pszFileName, cszFileName, NULL, NULL

    ; now get the profile string
    ;  LPCTSTR lpAppName,        // points to section name (m_bstrFolderName) 
    ;  LPCTSTR lpKeyName,        // points to key name (what WE choose to get)
    ;                             // basically just FolderName
    ;  LPCTSTR lpDefault,        // points to default string
    ;  LPTSTR lpReturnedString,  // points to destination buffer
    ;  DWORD nSize,              // size of destination buffer
    ;  LPCTSTR lpFileName        // points to initialization filename (m_Parent.FileName)
    invoke GetPrivateProfileString, pszSection, pszKeyName, ADDR szNULL, ADDR szData, 257, pszFileName
    invoke MultiByteToWideChar, CP_ACP, 0, ADDR szData, -1, ADDR wszData, 257
    invoke SysReAllocString, pbstrData, ADDR wszData
    invoke CoTaskMemFree, pszSection    ; frees all our heap (we made it in one chunk)
	ret
GetPrivateProfileBSTRING ENDP
;-------------------------------------------------------------------------------
END