;-------------------------------------------------------------------------------
;
; bstrLib procedure NameFromPathName    PROTO :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke NameFromPathName, bstrSamplePath, addr bstrName
;
; Description: extracts the file name from bstrSamplePath (a filepathname)
;   and returns it in *bstrName
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
NameFromPathName    PROC PUBLIC bstrFileName:DWORD, pbstrName:DWORD
    LOCAL pName:DWORD
    
    mov edx, bstrFileName
    mov ecx, edx
    .REPEAT
        mov ax, WORD PTR [edx]
        .IF ax == 92 ; "\" in unicode (ASCII codepage)
            mov ecx, edx
        .ENDIF
        add edx, 2
    .UNTIL  ax == 0
    ; ecx now points to the last "\"        
    add ecx, 2                ; point to name
    mov pName, ecx
    ; now copy JUST the name
    invoke SysReAllocString, pbstrName, pName
    xor eax, eax
    ret
NameFromPathName ENDP

;-------------------------------------------------------------------------------
end 

