;-------------------------------------------------------------------------------
;
; WritePrivateProfileBSTRING    PROTO :DWORD, :DWORD, :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
;   useage prototype
;    invoke WritePrivateProfileBSTRING, bstrSection, bstrKeyName, 
;                                       bstrData, bstrFileName
;   follows same convention of WritePrivateProfileString, but uses BSTR.
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------
include \masm32\include\ole32.inc
;include \masm32\include\shell32.inc
include \masm32\include\oleaut32.inc
include \masm32\include\kernel32.inc

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
WritePrivateProfileBSTRING    PROC PUBLIC bstrSection, bstrKeyName, bstrData, bstrFileName
    LOCAL pszSection:DWORD, pszKeyName:DWORD, pszData:DWORD, pszFileName:DWORD
    LOCAL cszSection:DWORD, cszKeyName:DWORD, cszData:DWORD, cszFileName:DWORD
    LOCAL cCount:DWORD,     retval:DWORD

	; get the individual length, and total length of our bstr's
    invoke SysStringByteLen, bstrSection
    add eax, 2      ; allow for trailing zero
    mov cszSection, eax
    mov cCount, eax
    mov pszKeyName, eax     ; offset for pointer 

    invoke SysStringByteLen, bstrKeyName
    add eax, 2      ; allow for trailing zero
    mov cszKeyName, eax
    add cCount, eax
    mov eax, cCount
    mov pszData, eax    	; offset for pointer

    invoke SysStringByteLen, bstrData
    add eax, 2      ; allow for trailing zero
    mov cszData, eax
    add cCount, eax
    mov eax, cCount
    mov pszFileName, eax    ; offset for pointer

    invoke SysStringByteLen, bstrFileName
    add eax, 2      ; allow for trailing zero
    mov cszFileName, eax
    add cCount, eax

    invoke CoTaskMemAlloc, cCount
    ; now make our pointers
    mov pszSection, eax     ; has offset of zero
    add pszKeyName, eax
    add pszData, eax
    add pszFileName, eax
    ; convert wide strings to ascii
	invoke WideCharToMultiByte, CP_ACP, 0, bstrSection,  -1, pszSection,  cszSection,  NULL, NULL
    invoke WideCharToMultiByte, CP_ACP, 0, bstrKeyName,  -1, pszKeyName,  cszKeyName,  NULL, NULL
    invoke WideCharToMultiByte, CP_ACP, 0, bstrData,     -1, pszData,     cszData,     NULL, NULL
    invoke WideCharToMultiByte, CP_ACP, 0, bstrFileName, -1, pszFileName, cszFileName, NULL, NULL

    ; now write the profile string
    ;  LPCTSTR lpAppName,         // points to section name (m_bstrFolderName) 
    ;  LPCTSTR lpKeyName,         // points to key name (what WE choose to get)
    ;  LPTSTR lpString,  	      // points to data to write buffer
    ;  LPCTSTR lpFileName         // points to initialization filename (m_Parent.FileName)
    invoke WritePrivateProfileString, pszSection, pszKeyName, pszData, pszFileName
	mov retval, eax
    invoke CoTaskMemFree, pszSection    ; frees all our heap (we made it in one chunk)
	mov eax, retval
	ret
WritePrivateProfileBSTRING ENDP
;-------------------------------------------------------------------------------
END