;-------------------------------------------------------------------------------
;  colibrary procedure ComPtrAssign 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
;  revised 1/10/01 to add S_OK retval
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc
include     \masm32\COM\include\oaidl.inc

.code
;-------------------------------------------------------------------------------

ComPtrAssign PROC PUBLIC pp:DWORD, lp:DWORD

;-------------------------------------------------------------------------------
; COM 'smart' pointer assignment
; (we can't do smart pointers, but this routine is handy none the less)
;
; performes pp <== lp
;
;  first releases any existing pointer in pp
;  performs the AddRef on lp
;
; EXAMPLE:
; invoke ComPtrAssign, ADDR pointerB, ADDR pointerA
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------

    .IF lp
        coinvoke lp, IUnknown, AddRef
    .ENDIF
    mov ecx, pp
    mov ecx, [ecx]
    .IF ecx
        coinvoke ecx, IUnknown, Release
    .ENDIF
    mov eax, lp
    mov ecx, pp
    mov [ecx], eax
    xor eax, eax    ; return S_OK
    ret
ComPtrAssign ENDP
;-------------------------------------------------------------------------------

end
