;-------------------------------------------------------------------------------
;  colibrary procedure DllCanUnloadNow
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\ole32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_ObjectCount:DWORD       


.code
;-------------------------------------------------------------------------------

DllCanUnloadNow PROC PUBLIC
             
;-------------------------------------------------------------------------------
; COM server dll main export
;   Determines whether the DLL that implements this function is in use. 
;   If not, the caller can safely unload the DLL from memory.
;   
;
; EXAMPLE:
;   invoke DllGetClassObject, ADDR clsid, ADDR iid:DWORD, ADDR pv
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    .IF g_ObjectCount
        mov eax, S_FALSE
    .ELSEIF
        xor eax, eax            ; mov eax, S_OK
    .ENDIF
    ret
DllCanUnloadNow ENDP
;-------------------------------------------------------------------------------

end
