;-------------------------------------------------------------------------------
;  colibrary procedure NDRelease
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

NDRelease PROC PUBLIC this_:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the non-delegated IUnknown::Release function
;
;  performs the Release function, destroying the COM object if necessary
;
; EXAMPLE:
;   coinvoke ppv, NDIUnknown, Release
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL pBase:DWORD, pMember:DWORD

    mov edx, this_                                  ; get object
    mov edx, (ObjectEntry PTR[edx]).m_pBase         ; walk to base data
    mov pBase, edx
    dec (ObjectData PTR[edx]).m_RefCount        
    mov eax, (ObjectData PTR[edx]).m_RefCount
    .IF ( eax == 0 )
        ; ref count droped to zero, delete this_ object 
        ; call the destructor
        mov edx, pBase
        mov ecx, (ObjectData PTR[edx]).m_pClassItem
        mov ecx, (ClassItem PTR[ecx]).m_pDestructor
        .IF ( ecx )
           ; need to call destructor function
            invoke Destructor PTR ecx, this_
        .ENDIF
        mov edx, pBase    
        mov ecx, (ObjectData PTR [edx]).m_pti       ; walk to type info
        .IF ( ecx )
            ; need to release the type info interface
            coinvoke ecx, IUnknown, Release
        .ENDIF
        mov edx, pBase    
        invoke DeallocObject, edx
		xor eax, eax        ; return zero
        ret
    .ENDIF            
    mov edx, this_
    mov edx, (ObjectEntry PTR[edx]).m_pBase         ; return the ref count
    ret
NDRelease ENDP
;-------------------------------------------------------------------------------

end
