;-------------------------------------------------------------------------------
;  colibrary procedure QueryInterface 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

QueryInterface PROC PUBLIC this_:DWORD, iid:DWORD,  ppv:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the delegated IUnknown::QueryInterface function
;
;  a delegated QueryInterface passes off the method to the contained pIUnkOuter
;
; EXAMPLE:
;   coinvoke ppv, IUnknown, QueryInterface, ADDR px, ADDR IX
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    mov eax, this_                                ; get object
    mov eax, (ObjectEntry PTR[eax]).m_pBase       ; walk to base data
    mov ecx, (ObjectData PTR[eax]).m_pUnkOuter    ; walk to delegated IUnknown ptr
    coinvoke ecx, IUnknown, QueryInterface, iid, ppv
    ret
QueryInterface ENDP
;-------------------------------------------------------------------------------

end
