;-------------------------------------------------------------------------------
; MyCom2.dll        copyright 7/15/00 Ernest J Murphy
;
;  sample project to illustrate how to use CoLib, a Component Object Library 
;
;-------------------------------------------------------------------------------

.NOLIST  ; keep the list file small, don't add the std libs to it.
.386
.model flat, stdcall
option casemap:none ; case sensitive

;-------------------------------------------------------------------------------
include     \masm32\include\windows.inc
include     \masm32\include\user32.inc
include     \masm32\include\kernel32.inc
include     \masm32\include\advapi32.inc    
include     \masm32\include\oleaut32.inc
include     \masm32\include\masm32.inc
include     \masm32\include\ole32.inc
include     \masm32\com\include\oaidl.inc   ; basic COM definitions
include     \masm32\com\include\colib.inc   ; the new library

include     IMyCom2.inc

includelib  \masm32\lib\user32.lib
includelib  \masm32\lib\kernel32.lib
includelib  \masm32\lib\advapi32.lib
includelib  \masm32\lib\oleaut32.lib
includelib  \masm32\lib\ole32.lib
includelib  \masm32\lib\gdi32.lib
includelib  \masm32\lib\shell32.lib
includelib  \masm32\lib\user32.lib
includelib  \masm32\lib\comdlg32.lib

includelib  \masm32\lib\masm32.lib

includelib  \masm32\com\colib\colib.lib ; the new library

PUBLIC ClassMap                             ; need to export ONLY the ClassMap

;-------------------------------------------------------------------------------
.LISTALL
.data

; describe the classes inside the DLL
ClassMap    ClassItem   { pCLSID_MyCom2, DISPINTERFACE + SUPPLY_TYPE_INFO, \
                          OFFSET MyCom2TypeLibInfo, OFFSET MyCom2IMap,     \
                          CreateMyCom2, NULL, NULL, SIZEOF MyCom2Object }
            END_CLASS_MAP

; describe the MyCom2 object's interfaces
MyCom2IMap  InterfaceItem { pIID_IMyCom2,  OFFSET vtableIMyCom2 }
            END_INTERFACE_MAP

; describe the type libraries
MyCom2TypeLibInfo   TypeLibInfo     { pLIBID_MyCom2, 1, 0 }     

; describe the MyCom2 object itself (takes 2 steps)
; step 1
MyCom2ObjData   STRUCT                  ; MyCom2 object private data struct
    m_Value         DWORD           0   ; Value (private data member)
MyCom2ObjData   ENDS

; step 2
MyCom2Object    STRUCT
    ObjectData0     ObjectData      { } ; base values
    MyCom2ObjData0  MyCom2ObjData   { } ; custom object data
    ObjectEntry0    ObjectEntry     { } ; delegated Unknown
    ObjectEntry1    ObjectEntry     { } ; IMyCom2
MyCom2Object    ENDS

; fill in the vtable
vtableIMyCom2       IMyCom2     { pvtIDispatch, GetValue, SetValue, RaiseValue }

; define the interface IID's
DeclareGuid IID_IMyCom2
DeclareGuid CLSID_MyCom2
DeclareGuid LIBID_MyCom2

;-------------------------------------------------------------------------------
.code
CreateMyCom2 PROC this_:DWORD
    pObjectData this_, edx  ; cast this_ to object data
    xor eax, eax                                ; get variable
    mov (MyCom2ObjData ptr [edx]).m_Value, eax  ; store new value   
    xor eax, eax                                ; return S_OK
    ret
CreateMyCom2 ENDP

;-------------------------------------------------------------------------------
GetValue PROC this_:DWORD, pval:DWORD   ; GetValue for the IMyCom Interface
    pObjectData this_, edx                      ; cast this_ to object data
    mov eax, (MyCom2ObjData ptr [edx]).m_Value  ; get object data value
    mov ecx, pval                               ; get ptr to variable for return
    mov [ecx], eax                              ; mov value to variable
    xor eax, eax                                ; return S_OK
    ret
GetValue ENDP

;-------------------------------------------------------------------------------
SetValue PROC this_:DWORD, val:DWORD    ; SetValue for the IMyCom Interface
    pObjectData this_, edx  ; cast this_ to object data
    mov eax, val                                ; get variable
    mov (MyCom2ObjData ptr [edx]).m_Value, eax  ; store new value   
    xor eax, eax                                ; return S_OK
    ret
SetValue ENDP

;-------------------------------------------------------------------------------
RaiseValue  PROC this_:DWORD, val:DWORD ; RaiseValue for the IMyCom Interface
    pObjectData this_, edx  ; cast this_ to object data
    mov eax, val                                ; get variable
    add (MyCom2ObjData ptr [edx]).m_Value, eax  ; add new value to current value
    xor eax, eax                                ; return S_OK
    ret
RaiseValue ENDP

;-------------------------------------------------------------------------------
end DllMain
