; 

    .486                      ; force 32 bit code
    .model flat, stdcall      ; memory model & calling convention
    option casemap :none      ; case sensitive
 
    .code

; 

OPTION PROLOGUE:NONE 
OPTION EPILOGUE:NONE 

align 4

szMonoSpace proc src:DWORD

  ; -------------------------------------------------------
  ; trim tabs and spaces from each end of "src" and replace
  ; any duplicate tabs and spaces with a single space. The
  ; result is written back to the source string address.
  ; -------------------------------------------------------
    mov ecx, [esp+4]
    xor eax, eax
    sub ecx, 1
    mov edx, [esp+4]
    jmp ftrim                       ; trim the start of the string

  wspace:
    mov BYTE PTR [edx], 32          ; always write a space
    add edx, 1

  ftrim:
    add ecx, 1
    cmp BYTE PTR [ecx], 32          ; throw away space
    je ftrim
    cmp BYTE PTR [ecx], 9           ; throw away tab
    je ftrim
    sub ecx, 1

  stlp:
    add ecx, 1
    cmp BYTE PTR [ecx], 32          ; test for space
    je wspace
    cmp BYTE PTR [ecx], 9           ; test for tab
    je wspace
    mov al, [ecx]
    mov [edx], al                   ; write the non space character
    add edx, 1
    test al, al                     ; if its not zero, loop back
    jne stlp

    cmp BYTE PTR [edx-2], 32        ; test for a single trailing space
    jne quit
    mov BYTE PTR [edx-2], 0         ; overwrite it with zero if it is

  quit:
    mov eax, [esp+4]

    ret 4

szMonoSpace endp

OPTION PROLOGUE:PrologueDef 
OPTION EPILOGUE:EpilogueDef 

; 

end
