RAND32		PROTO	:DWORD
InitRand32  PROTO
; random number generator by NaN
; (modified a bit to make it a procedure by Exagone)
.data? 
	NaNRand dd ?
.code

SWAP MACRO M1:REQ, M2:REQ
	xor M1, M2
	xor M2, M1
	xor M1, M2
ENDM

InitRand32	proc
  db 0fh,31h 
  shr eax, 2
  add eax, 1
  mov NaNRand, eax
ret
InitRand32 endp  
  
RAND32 proc base:DWORD
  ; Random number generator based on the Real time clock
  ; and the Park, Miller random number algorithm
  ;
  ; Coded by NaN for WIN32ASM
  ; May 5, 2001
  ; rev 2.
  push ecx
  push edx


  mov eax, NaNRand    
  mov edx,0
  mov ecx, 127773 ;q
  div ecx      ; eax == floor( seed / q)
               ; edx == remainder
  SWAP eax, edx
  push edx
  mov ecx, 16807
  mul ecx      ; eax = mul of remainder * a
  pop edx      ; edx == floor of seed/q
  
  SWAP eax, edx
  push edx
  mov ecx, 2836
  mul ecx
  pop edx      ; edx == mull of rem * a
               ; eax == mull of seed/q * r
               
  sub edx, eax
  mov eax, edx    
  mov NaNRand, eax ; save next seed 
  mov ecx, base
  mov edx, 0
  div ecx
  mov eax, edx
  pop edx
  pop ecx
 ret
RAND32 endp