package ru.bmstu.streamgenerator.controller;

import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.bmstu.streamgenerator.model.MessagesCountProperties;
import ru.bmstu.streamgenerator.producer.StreamGenerator;

@RestController
@RequestMapping("/producer")
@RequiredArgsConstructor
public class ProducerPropertiesController {

    private final StreamGenerator streamGenerator;

    @PostMapping("/frequency")
    public void setProducerFrequency(@RequestBody MessagesCountProperties properties) {
        streamGenerator.setMessagesPerSecond(properties.getMessagesPerSecond());
    }

}
